/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import org.cyclops.commoncapabilities.CommonCapabilities;
import org.cyclops.commoncapabilities.Reference;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;
import org.cyclops.commoncapabilities.ingredient.DataComparator;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.DummyConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tracking.Analytics;
import org.cyclops.cyclopscore.tracking.IModVersion;
import org.cyclops.cyclopscore.tracking.Versions;

public class GeneralConfig
extends DummyConfig {
    @ConfigurableProperty(category="core", comment="If the recipe loader should crash when finding invalid recipes.", requiresMcRestart=true, configLocation=ModConfig.Type.SERVER)
    public static boolean crashOnInvalidRecipe = false;
    @ConfigurableProperty(category="core", comment="If mod compatibility loader should crash hard if errors occur in that process.", requiresMcRestart=true, configLocation=ModConfig.Type.SERVER)
    public static boolean crashOnModCompatCrash = false;
    @ConfigurableProperty(category="core", comment="If an anonymous mod startup analytics request may be sent to our analytics service.")
    public static boolean analytics = true;
    @ConfigurableProperty(category="core", comment="If the version checker should be enabled.")
    public static boolean versionChecker = true;
    @ConfigurableProperty(category="machine", comment="The data component types that should be filtered away when checking equality.", configLocation=ModConfig.Type.SERVER)
    public static List<String> ignoreDataComponentsForEqualityFilters = Lists.newArrayList();
    @ConfigurableProperty(category="core", comment="Only enable this if you know what you are doing, as this will cause lag! This will log checks to the DataComparator where equal items have unequal data components.")
    public static boolean debugLogUnequalItemDataComponents = false;

    public GeneralConfig() {
        super((ModBase)CommonCapabilities._instance, "general");
        CommonCapabilities._instance.getModEventBus().register((Object)this);
    }

    public void onRegistered() {
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_INVALID_RECIPE, (Object)crashOnInvalidRecipe);
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_MODCOMPAT_CRASH, (Object)crashOnModCompatCrash);
        if (analytics) {
            Analytics.registerMod((ModBase)this.getMod(), (String)"UA-65307010-7");
        }
        if (versionChecker) {
            Versions.registerMod((ModBase)this.getMod(), (IModVersion)CommonCapabilities._instance, (String)Reference.VERSION_URL);
        }
    }

    @SubscribeEvent
    public void onConfigLoad(ModConfigEvent.Loading event) {
        this.updateNbtComparator();
    }

    @SubscribeEvent
    public void onConfigReload(ModConfigEvent.Reloading event) {
        this.updateNbtComparator();
    }

    protected void updateNbtComparator() {
        ItemMatch.DATA_COMPARATOR = DataComparator.INSTANCE = new DataComparator(ignoreDataComponentsForEqualityFilters.stream().map(ResourceLocation::parse).collect(Collectors.toSet()));
    }
}

