/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile.tasks;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.embeddedt.embeddium.api.ChunkDataBuiltEvent;
import org.embeddedt.embeddium.api.render.chunk.BlockRenderContext;
import org.embeddedt.embeddium.impl.chunk.MeshAppenderRenderer;
import org.embeddedt.embeddium.impl.model.UnwrappableBakedModel;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBufferSorter;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildBuffers;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildContext;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.pipeline.BlockRenderCache;
import org.embeddedt.embeddium.impl.render.chunk.compile.tasks.ChunkBuilderTask;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionInfo;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionMeshParts;
import org.embeddedt.embeddium.impl.render.chunk.terrain.DefaultTerrainRenderPasses;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.util.task.CancellationToken;
import org.embeddedt.embeddium.impl.world.WorldSlice;
import org.embeddedt.embeddium.impl.world.cloned.ChunkRenderContext;

public class ChunkBuilderMeshingTask
extends ChunkBuilderTask<ChunkBuildOutput> {
    private final RandomSource random = new SingleThreadedRandomSource(42L);
    private final RenderSection render;
    private final ChunkRenderContext renderContext;
    private final int buildTime;
    private Vec3 camera = Vec3.ZERO;

    public ChunkBuilderMeshingTask(RenderSection render, ChunkRenderContext renderContext, int time) {
        this.render = render;
        this.renderContext = renderContext;
        this.buildTime = time;
    }

    public ChunkBuilderMeshingTask withCameraPosition(Vec3 camera) {
        this.camera = camera;
        return this;
    }

    @Override
    public ChunkBuildOutput execute(ChunkBuildContext buildContext, CancellationToken cancellationToken) {
        BuiltSectionInfo.Builder renderData = new BuiltSectionInfo.Builder();
        VisGraph occluder = new VisGraph();
        ChunkBuildBuffers buffers = buildContext.buffers;
        buffers.init(renderData, this.render.getSectionIndex());
        BlockRenderCache cache = buildContext.cache;
        cache.init(this.renderContext);
        WorldSlice slice = cache.getWorldSlice();
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        int maxX = minX + 16;
        int maxY = minY + 16;
        int maxZ = minZ + 16;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(minX, minY, minZ);
        BlockPos.MutableBlockPos modelOffset = new BlockPos.MutableBlockPos();
        BlockRenderContext context = new BlockRenderContext(slice);
        try {
            for (int y = minY; y < maxY; ++y) {
                if (cancellationToken.isCancelled()) {
                    return null;
                }
                for (int z = minZ; z < maxZ; ++z) {
                    for (int x = minX; x < maxX; ++x) {
                        BlockEntityRenderer renderer;
                        BlockEntity entity;
                        FluidState fluidState;
                        BlockState blockState = slice.getBlockState(x, y, z);
                        if (blockState.isAir() && blockState.getRenderShape() == RenderShape.INVISIBLE && !blockState.hasBlockEntity()) continue;
                        blockPos.set(x, y, z);
                        modelOffset.set(x & 0xF, y & 0xF, z & 0xF);
                        if (blockState.getRenderShape() == RenderShape.MODEL) {
                            BakedModel model = cache.getBlockModels().getBlockModel(blockState);
                            ModelData modelData = model.getModelData(context.localSlice(), (BlockPos)blockPos, blockState, slice.getModelData((BlockPos)blockPos));
                            long seed = blockState.getSeed((BlockPos)blockPos);
                            this.random.setSeed(seed);
                            model = UnwrappableBakedModel.unwrapIfPossible(model, this.random);
                            this.random.setSeed(seed);
                            for (RenderType layer : model.getRenderTypes(blockState, this.random, modelData)) {
                                context.update((BlockPos)blockPos, (BlockPos)modelOffset, blockState, model, seed, modelData, layer);
                                cache.getBlockRenderer().renderModel(context, buffers);
                            }
                        }
                        if (!(fluidState = blockState.getFluidState()).isEmpty()) {
                            cache.getFluidRenderer().render(slice, fluidState, (BlockPos)blockPos, (BlockPos)modelOffset, buffers);
                        }
                        if (blockState.hasBlockEntity() && (entity = slice.getBlockEntity((BlockPos)blockPos)) != null && (renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(entity)) != null) {
                            renderData.addBlockEntity(entity, !renderer.shouldRenderOffScreen(entity));
                        }
                        if (!blockState.isSolidRender((BlockGetter)slice, (BlockPos)blockPos)) continue;
                        occluder.setOpaque((BlockPos)blockPos);
                    }
                }
            }
            MeshAppenderRenderer.renderMeshAppenders(this.renderContext.getMeshAppenders(), context.localSlice(), this.renderContext.getOrigin(), buffers);
        }
        catch (ReportedException ex) {
            throw this.fillCrashInfo(ex.getReport(), slice, (BlockPos)blockPos);
        }
        catch (Throwable ex) {
            throw this.fillCrashInfo(CrashReport.forThrowable((Throwable)ex, (String)"Encountered exception while building chunk meshes"), slice, (BlockPos)blockPos);
        }
        Reference2ReferenceOpenHashMap meshes = new Reference2ReferenceOpenHashMap();
        for (TerrainRenderPass pass : DefaultTerrainRenderPasses.ALL) {
            BuiltSectionMeshParts mesh = buffers.createMesh(pass);
            if (mesh == null) continue;
            if (pass.isSorted()) {
                Objects.requireNonNull(mesh.getIndexData());
                ChunkBufferSorter.sort(mesh.getIndexData(), mesh.getSortState(), (float)this.camera.x - (float)minX, (float)this.camera.y - (float)minY, (float)this.camera.z - (float)minZ);
            }
            meshes.put(pass, mesh);
            renderData.addRenderPass(pass);
        }
        renderData.setOcclusionData(occluder.resolve());
        ChunkDataBuiltEvent.BUS.post(new ChunkDataBuiltEvent(renderData));
        return new ChunkBuildOutput(this.render, renderData.build(), (Map<TerrainRenderPass, BuiltSectionMeshParts>)meshes, this.buildTime);
    }

    private ReportedException fillCrashInfo(CrashReport report, WorldSlice slice, BlockPos pos) {
        CrashReportCategory crashReportSection = report.addCategory("Block being rendered", 1);
        BlockState state = null;
        try {
            state = slice.getBlockState(pos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CrashReportCategory.populateBlockDetails((CrashReportCategory)crashReportSection, (LevelHeightAccessor)slice, (BlockPos)pos, (BlockState)state);
        crashReportSection.setDetail("Chunk section", (Object)this.render);
        if (this.renderContext != null) {
            crashReportSection.setDetail("Render context volume", (Object)this.renderContext.getVolume());
        }
        return new ReportedException(report);
    }
}

