/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import net.minecraft.client.gui.screens.Screen;

public class ShaderModBridge {
    private static final MethodHandle SHADERS_ENABLED;
    private static final MethodHandle SHADERS_OPEN_SCREEN;
    private static final MethodHandle NVIDIUM_ENABLED;

    public static boolean isNvidiumEnabled() {
        if (NVIDIUM_ENABLED != null) {
            try {
                return NVIDIUM_ENABLED.invokeExact();
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    public static boolean areShadersEnabled() {
        if (SHADERS_ENABLED != null) {
            try {
                return SHADERS_ENABLED.invokeExact();
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isShaderModPresent() {
        return SHADERS_ENABLED != null;
    }

    public static boolean emulateLegacyColorBrightnessFormat() {
        return ShaderModBridge.areShadersEnabled() || ShaderModBridge.isNvidiumEnabled();
    }

    public static Object openShaderScreen(Screen parentScreen) {
        if (SHADERS_OPEN_SCREEN != null) {
            try {
                return SHADERS_OPEN_SCREEN.invoke(parentScreen);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        MethodHandle shadersEnabled = null;
        MethodHandle shaderOpenScreen = null;
        try {
            Class<?> irisApiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Method instanceGetter = irisApiClass.getDeclaredMethod("getInstance", new Class[0]);
            Object irisApiInstance = instanceGetter.invoke(null, new Object[0]);
            shadersEnabled = MethodHandles.lookup().unreflect(irisApiClass.getDeclaredMethod("isShaderPackInUse", new Class[0])).bindTo(irisApiInstance);
            shaderOpenScreen = MethodHandles.lookup().unreflect(irisApiClass.getDeclaredMethod("openMainIrisScreenObj", Object.class)).bindTo(irisApiInstance);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            // empty catch block
        }
        SHADERS_ENABLED = shadersEnabled;
        SHADERS_OPEN_SCREEN = shaderOpenScreen;
        MethodHandle nvidiumEnabled = null;
        try {
            Class<?> nvidiumClass = Class.forName("me.cortex.nvidium.Nvidium");
            nvidiumEnabled = MethodHandles.lookup().findStaticGetter(nvidiumClass, "IS_ENABLED", Boolean.TYPE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        NVIDIUM_ENABLED = nvidiumEnabled;
    }
}

