/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.mixin.features.render.gui.font;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import org.embeddedt.embeddium.api.math.MatrixHelper;
import org.embeddedt.embeddium.api.util.ColorABGR;
import org.embeddedt.embeddium.api.vertex.buffer.VertexBufferWriter;
import org.embeddedt.embeddium.api.vertex.format.common.GlyphVertex;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BakedGlyph.class})
public class GlyphRendererMixin {
    @Shadow
    @Final
    private float left;
    @Shadow
    @Final
    private float right;
    @Shadow
    @Final
    private float up;
    @Shadow
    @Final
    private float down;
    @Shadow
    @Final
    private float u0;
    @Shadow
    @Final
    private float v0;
    @Shadow
    @Final
    private float v1;
    @Shadow
    @Final
    private float u1;

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderFast(boolean italic, float x, float y, Matrix4f matrix, VertexConsumer vertexConsumer, float red, float green, float blue, float alpha, int light, CallbackInfo ci) {
        if (this.drawFast(italic, x, y, matrix, vertexConsumer, red, green, blue, alpha, light)) {
            ci.cancel();
        }
    }

    private boolean drawFast(boolean italic, float x, float y, Matrix4f matrix, VertexConsumer vertexConsumer, float red, float green, float blue, float alpha, int light) {
        VertexBufferWriter writer = VertexBufferWriter.tryOf(vertexConsumer);
        if (writer == null) {
            return false;
        }
        float x1 = x + this.left;
        float x2 = x + this.right;
        float h1 = y + this.up;
        float h2 = y + this.down;
        float w1 = italic ? 1.0f - 0.25f * this.up : 0.0f;
        float w2 = italic ? 1.0f - 0.25f * this.down : 0.0f;
        int color = ColorABGR.pack(red, green, blue, alpha);
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(112);
            GlyphRendererMixin.write(ptr, matrix, x1 + w1, h1, 0.0f, color, this.u0, this.v0, light);
            GlyphRendererMixin.write(ptr += 28L, matrix, x1 + w2, h2, 0.0f, color, this.u0, this.v1, light);
            GlyphRendererMixin.write(ptr += 28L, matrix, x2 + w2, h2, 0.0f, color, this.u1, this.v1, light);
            GlyphRendererMixin.write(ptr += 28L, matrix, x2 + w1, h1, 0.0f, color, this.u1, this.v0, light);
            ptr += 28L;
            writer.push(stack, buffer, 4, GlyphVertex.FORMAT);
        }
        return true;
    }

    @Unique
    private static void write(long buffer, Matrix4f matrix, float x, float y, float z, int color, float u, float v, int light) {
        float x2 = MatrixHelper.transformPositionX(matrix, x, y, z);
        float y2 = MatrixHelper.transformPositionY(matrix, x, y, z);
        float z2 = MatrixHelper.transformPositionZ(matrix, x, y, z);
        GlyphVertex.put(buffer, x2, y2, z2, color, u, v, light);
    }
}

