/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.mixin.core.model.quad;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import org.embeddedt.embeddium.impl.model.quad.BakedQuadView;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFlags;
import org.embeddedt.embeddium.impl.render.chunk.sprite.SpriteTransparencyLevel;
import org.embeddedt.embeddium.impl.render.chunk.sprite.SpriteTransparencyLevelHolder;
import org.embeddedt.embeddium.impl.util.ModelQuadUtil;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BakedQuad.class})
public class BakedQuadMixin
implements BakedQuadView {
    @Shadow
    @Final
    protected int[] vertices;
    @Shadow
    @Final
    protected TextureAtlasSprite sprite;
    @Shadow
    @Final
    protected int tintIndex;
    @Shadow
    @Final
    protected Direction direction;
    @Shadow
    @Final
    private boolean shade;
    @Shadow(remap=false)
    @Final
    private boolean hasAmbientOcclusion;
    @Unique
    private int flags;
    @Unique
    private int normal;
    @Unique
    private ModelQuadFacing normalFace;

    @Override
    public float getX(int idx) {
        return Float.intBitsToFloat(this.vertices[ModelQuadUtil.vertexOffset(idx) + 0]);
    }

    @Override
    public float getY(int idx) {
        return Float.intBitsToFloat(this.vertices[ModelQuadUtil.vertexOffset(idx) + 0 + 1]);
    }

    @Override
    public float getZ(int idx) {
        return Float.intBitsToFloat(this.vertices[ModelQuadUtil.vertexOffset(idx) + 0 + 2]);
    }

    @Override
    public int getColor(int idx) {
        return this.vertices[ModelQuadUtil.vertexOffset(idx) + 3];
    }

    @Override
    public TextureAtlasSprite getSprite() {
        return this.sprite;
    }

    @Override
    public float getTexU(int idx) {
        return Float.intBitsToFloat(this.vertices[ModelQuadUtil.vertexOffset(idx) + 4]);
    }

    @Override
    public float getTexV(int idx) {
        return Float.intBitsToFloat(this.vertices[ModelQuadUtil.vertexOffset(idx) + 4 + 1]);
    }

    @Override
    public int getLight(int idx) {
        return this.vertices[ModelQuadUtil.vertexOffset(idx) + 6];
    }

    @Override
    public int getForgeNormal(int idx) {
        return this.vertices[ModelQuadUtil.vertexOffset(idx) + 7];
    }

    @Override
    public int getFlags() {
        int f = this.flags;
        if ((f & Integer.MIN_VALUE) == 0) {
            this.flags = f = ModelQuadFlags.getQuadFlags(this, this.direction, f);
        }
        return f;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    @Nullable
    public SpriteTransparencyLevel getTransparencyLevel() {
        if (this.sprite != null && (this.flags & 0x10) != 0) {
            return SpriteTransparencyLevelHolder.getTransparencyLevel(this.sprite);
        }
        return null;
    }

    @Override
    public int getColorIndex() {
        return this.tintIndex;
    }

    @Override
    public ModelQuadFacing getNormalFace() {
        ModelQuadFacing face = this.normalFace;
        if (face == null) {
            this.normalFace = face = ModelQuadUtil.findNormalFace(this.getComputedFaceNormal());
        }
        return face;
    }

    @Override
    public int getComputedFaceNormal() {
        int n = this.normal;
        if (n == 0) {
            this.normal = n = ModelQuadUtil.calculateNormal(this);
        }
        return n;
    }

    @Override
    public Direction getLightFace() {
        return this.direction;
    }

    @Override
    @Unique(silent=true)
    public boolean hasShade() {
        return this.shade;
    }

    @Override
    public boolean hasAmbientOcclusion() {
        return this.hasAmbientOcclusion;
    }
}

