/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.slot;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.GuiGraphicsExtended;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingOption;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.core.terminalstorage.slot.TerminalStorageSlotIngredient;

public class TerminalStorageSlotIngredientCraftingOption<T, M>
extends TerminalStorageSlotIngredient<T, M> {
    private final HandlerWrappedTerminalCraftingOption<T> craftingOption;

    public TerminalStorageSlotIngredientCraftingOption(IIngredientComponentTerminalStorageHandler<T, M> ingredientComponentViewHandler, T instance, HandlerWrappedTerminalCraftingOption<T> craftingOption) {
        super(ingredientComponentViewHandler, instance);
        this.craftingOption = craftingOption;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawGuiContainerLayer(AbstractContainerScreen gui, GuiGraphics guiGraphics, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, ITerminalStorageTabClient tab, int channel, @Nullable String label) {
        IIngredientComponentTerminalStorageHandler viewHandler = this.getIngredientComponentViewHandler();
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            long maxQuantity = ((TerminalStorageTabIngredientComponentClient)tab).getMaxQuantity(channel);
            viewHandler.drawInstance(guiGraphics, this.getInstance(), maxQuantity, null, gui, layer, partialTick, x, y, mouseX, mouseY, null);
            this.drawCraftLabel(guiGraphics, x, y);
        } else {
            long maxQuantity = ((TerminalStorageTabIngredientComponentClient)tab).getMaxQuantity(channel);
            this.getIngredientComponentViewHandler().drawInstance(guiGraphics, this.getInstance(), maxQuantity, label, gui, layer, partialTick, x, y, mouseX, mouseY, this.getTooltipLines());
        }
    }

    protected List<Component> getTooltipLines() {
        ArrayList tooltipLines = Lists.newArrayList();
        tooltipLines.add(Component.translatable((String)"gui.integratedterminals.terminal_storage.tooltip.requirements").withStyle(ChatFormatting.YELLOW));
        ITerminalCraftingOption<T> option = this.getCraftingOption().getCraftingOption();
        for (IngredientComponent<?, ?> inputComponent : option.getInputComponents()) {
            IIngredientMatcher matcher = inputComponent.getMatcher();
            for (Object inputInstance : option.getInputs(inputComponent)) {
                if (matcher.isEmpty(inputInstance)) continue;
                tooltipLines.add(Component.literal((String)String.format("%s- %s (%s)", ChatFormatting.GRAY, matcher.localize(inputInstance), matcher.getQuantity(inputInstance))));
            }
        }
        return tooltipLines;
    }

    public HandlerWrappedTerminalCraftingOption<T> getCraftingOption() {
        return this.craftingOption;
    }

    private void drawCraftLabel(GuiGraphics guiGraphics, int x, int y) {
        new GuiGraphicsExtended(guiGraphics).drawSlotText(Minecraft.getInstance().font, String.valueOf(ChatFormatting.GOLD) + L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.craft", (Object[])new Object[0]), x, y - 11);
    }
}

