/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.api.terminalstorage.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlanFlat;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingJobStatus;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingPlanFlatStatic;

public class TerminalCraftingPlanStatic<I>
implements ITerminalCraftingPlan<I> {
    private final I id;
    private final List<ITerminalCraftingPlan<I>> dependencies;
    private final List<IPrototypedIngredient<?, ?>> outputs;
    private TerminalCraftingJobStatus status;
    private final long craftingQuantity;
    private final List<IPrototypedIngredient<?, ?>> bufferedIngredients;
    private final List<List<IPrototypedIngredient<?, ?>>> lastMissingIngredients;
    private Label label;
    @Nullable
    private String unlocalizedLabelOverride;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;

    public TerminalCraftingPlanStatic(I id, List<ITerminalCraftingPlan<I>> dependencies, List<IPrototypedIngredient<?, ?>> outputs, TerminalCraftingJobStatus status, long craftingQuantity, List<IPrototypedIngredient<?, ?>> bufferedIngredients, List<List<IPrototypedIngredient<?, ?>>> lastMissingIngredients, Label label, long tickDuration, int channel, @Nullable String initiatorName) {
        this.id = id;
        this.dependencies = dependencies;
        this.outputs = outputs;
        this.status = status;
        this.craftingQuantity = craftingQuantity;
        this.bufferedIngredients = bufferedIngredients;
        this.lastMissingIngredients = lastMissingIngredients;
        this.label = label;
        this.unlocalizedLabelOverride = null;
        this.tickDuration = tickDuration;
        this.channel = channel;
        this.initiatorName = initiatorName;
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public List<ITerminalCraftingPlan<I>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<IPrototypedIngredient<?, ?>> getOutputs() {
        return this.outputs;
    }

    @Override
    public TerminalCraftingJobStatus getStatus() {
        return this.status;
    }

    @Override
    public long getCraftingQuantity() {
        return this.craftingQuantity;
    }

    @Override
    public List<IPrototypedIngredient<?, ?>> getBufferedIngredients() {
        return this.bufferedIngredients;
    }

    @Override
    public List<List<IPrototypedIngredient<?, ?>>> getLastMissingIngredients() {
        return this.lastMissingIngredients;
    }

    public Label getLabel() {
        return this.label;
    }

    @Nullable
    public String getUnlocalizedLabelOverride() {
        return this.unlocalizedLabelOverride;
    }

    public void setUnlocalizedLabelOverride(@Nullable String unlocalizedLabelOverride) {
        this.unlocalizedLabelOverride = unlocalizedLabelOverride;
    }

    @Override
    public String getUnlocalizedLabel() {
        if (this.unlocalizedLabelOverride == null) {
            return this.label.getUnlocalizedMessage();
        }
        return this.unlocalizedLabelOverride;
    }

    @Override
    public long getTickDuration() {
        return this.tickDuration;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    @Nullable
    public String getInitiatorName() {
        return this.initiatorName;
    }

    @Override
    public void setError(String unlocalizedError) {
        this.status = TerminalCraftingJobStatus.ERROR;
        this.unlocalizedLabelOverride = unlocalizedError;
    }

    @Override
    public ITerminalCraftingPlanFlat<I> flatten() {
        IndexedEntries indexedEntries = new IndexedEntries();
        HashSet handledPlans = new HashSet();
        TerminalCraftingPlanStatic.groupDependenciesByPrototype(indexedEntries, handledPlans, this);
        TerminalCraftingPlanFlatStatic<I> planFlat = new TerminalCraftingPlanFlatStatic<I>(this.getId(), indexedEntries.getEntries().stream().sorted((e1, e2) -> {
            if (e1.getQuantityMissing() != e2.getQuantityMissing()) {
                return Math.toIntExact(e2.getQuantityMissing() - e1.getQuantityMissing());
            }
            if (e1.getQuantityCrafting() != e2.getQuantityCrafting()) {
                return Math.toIntExact(e2.getQuantityCrafting() - e1.getQuantityCrafting());
            }
            if (e1.getQuantityToCraft() != e2.getQuantityToCraft()) {
                return Math.toIntExact(e2.getQuantityToCraft() - e1.getQuantityToCraft());
            }
            if (e1.getQuantityInStorage() != e2.getQuantityInStorage()) {
                return Math.toIntExact(e2.getQuantityInStorage() - e1.getQuantityInStorage());
            }
            return 0;
        }).toList(), this.getOutputs(), this.getStatus(), this.getLabel(), this.getTickDuration(), this.getChannel(), this.getInitiatorName());
        if (this.getUnlocalizedLabelOverride() != null) {
            planFlat.setUnlocalizedLabelOverride(this.getUnlocalizedLabelOverride());
        }
        return planFlat;
    }

    protected static <I> void groupDependenciesByPrototype(IndexedEntries indexedEntries, Set<I> handledPlans, ITerminalCraftingPlan<I> plan) {
        long quantity;
        TerminalCraftingPlanFlatStatic.Entry entry;
        if (handledPlans.contains(plan.getId())) {
            return;
        }
        handledPlans.add(plan.getId());
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getOutputs()) {
            entry = indexedEntries.get(iPrototypedIngredient);
            quantity = IndexedEntries.getQuantity(iPrototypedIngredient);
            if (plan.getStatus() == TerminalCraftingJobStatus.ERROR || plan.getStatus() == TerminalCraftingJobStatus.INVALID || plan.getStatus() == TerminalCraftingJobStatus.INVALID_INPUTS) {
                if (plan.getDependencies().isEmpty()) {
                    entry.setQuantityMissing(entry.getQuantityMissing() + quantity);
                } else {
                    entry.setQuantityToCraft(entry.getQuantityToCraft() + quantity);
                }
            }
            if (plan.getStatus() == TerminalCraftingJobStatus.QUEUEING || plan.getStatus() == TerminalCraftingJobStatus.PENDING_DEPENDENCIES || plan.getStatus() == TerminalCraftingJobStatus.PENDING_INPUTS || plan.getStatus() == TerminalCraftingJobStatus.UNSTARTED) {
                entry.setQuantityToCraft(entry.getQuantityToCraft() + quantity);
            }
            if (plan.getStatus() != TerminalCraftingJobStatus.CRAFTING && plan.getStatus() != TerminalCraftingJobStatus.FINISHED) continue;
            entry.setQuantityCrafting(entry.getQuantityCrafting() + quantity);
        }
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getBufferedIngredients()) {
            entry = indexedEntries.get(iPrototypedIngredient);
            quantity = IndexedEntries.getQuantity(iPrototypedIngredient);
            entry.setQuantityInStorage(entry.getQuantityInStorage() + quantity);
        }
        for (List list : plan.getLastMissingIngredients()) {
            IPrototypedIngredient output = (IPrototypedIngredient)list.stream().findFirst().get();
            TerminalCraftingPlanFlatStatic.Entry entry2 = indexedEntries.get(output);
            long quantity2 = IndexedEntries.getQuantity(output);
            entry2.setQuantityMissing(entry2.getQuantityMissing() + quantity2 * plan.getCraftingQuantity());
        }
        for (ITerminalCraftingPlan iTerminalCraftingPlan : plan.getDependencies()) {
            TerminalCraftingPlanStatic.groupDependenciesByPrototype(indexedEntries, handledPlans, iTerminalCraftingPlan);
        }
    }

    public static <I> CompoundTag serialize(HolderLookup.Provider lookupProvider, TerminalCraftingPlanStatic<I> plan, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        CompoundTag tag = new CompoundTag();
        tag.put("id", handler.serializeCraftingJobId(plan.getId()));
        ListTag dependencies = new ListTag();
        for (ITerminalCraftingPlan<I> iTerminalCraftingPlan : plan.getDependencies()) {
            dependencies.add((Object)TerminalCraftingPlanStatic.serialize(lookupProvider, (TerminalCraftingPlanStatic)iTerminalCraftingPlan, handler));
        }
        tag.put("dependencies", (Tag)dependencies);
        ListTag outputs = new ListTag();
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getOutputs()) {
            outputs.add((Object)IPrototypedIngredient.serialize((HolderLookup.Provider)lookupProvider, (IPrototypedIngredient)((PrototypedIngredient)iPrototypedIngredient)));
        }
        tag.put("outputs", (Tag)outputs);
        tag.putInt("status", plan.getStatus().ordinal());
        tag.putLong("craftingQuantity", plan.getCraftingQuantity());
        ListTag listTag = new ListTag();
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getBufferedIngredients()) {
            listTag.add((Object)IPrototypedIngredient.serialize((HolderLookup.Provider)lookupProvider, (IPrototypedIngredient)((PrototypedIngredient)iPrototypedIngredient)));
        }
        tag.put("bufferedIngredients", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (List<IPrototypedIngredient<?, ?>> lastMissingIngredient : plan.getLastMissingIngredients()) {
            ListTag lastMissingIngredientTag = new ListTag();
            for (IPrototypedIngredient<?, ?> prototypedIngredient : lastMissingIngredient) {
                lastMissingIngredientTag.add((Object)IPrototypedIngredient.serialize((HolderLookup.Provider)lookupProvider, (IPrototypedIngredient)((PrototypedIngredient)prototypedIngredient)));
            }
            listTag2.add((Object)lastMissingIngredientTag);
        }
        tag.put("lastMissingIngredients", (Tag)listTag2);
        tag.putInt("label", plan.label.ordinal());
        if (plan.unlocalizedLabelOverride != null) {
            tag.putString("unlocalizedLabelOverride", plan.unlocalizedLabelOverride);
        }
        tag.putLong("tickDuration", plan.getTickDuration());
        tag.putInt("channel", plan.getChannel());
        if (plan.getInitiatorName() != null) {
            tag.putString("initiatorName", plan.getInitiatorName());
        }
        return tag;
    }

    public static <I> TerminalCraftingPlanStatic<I> deserialize(HolderLookup.Provider lookupProvider, CompoundTag tag, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        if (!tag.contains("id")) {
            throw new IllegalArgumentException("Could not find an id entry in the given tag");
        }
        if (!tag.contains("dependencies", 9)) {
            throw new IllegalArgumentException("Could not find a dependencies entry in the given tag");
        }
        if (!tag.contains("outputs", 9)) {
            throw new IllegalArgumentException("Could not find a outputs entry in the given tag");
        }
        if (!tag.contains("status", 3)) {
            throw new IllegalArgumentException("Could not find a status entry in the given tag");
        }
        if (!tag.contains("craftingQuantity", 4)) {
            throw new IllegalArgumentException("Could not find a craftingQuantity entry in the given tag");
        }
        if (!tag.contains("bufferedIngredients", 9)) {
            throw new IllegalArgumentException("Could not find a bufferedIngredients entry in the given tag");
        }
        if (!tag.contains("lastMissingIngredients", 9)) {
            throw new IllegalArgumentException("Could not find a lastMissingIngredients entry in the given tag");
        }
        if (!tag.contains("label", 3)) {
            throw new IllegalArgumentException("Could not find a label entry in the given tag");
        }
        if (!tag.contains("tickDuration", 4)) {
            throw new IllegalArgumentException("Could not find a tickDuration entry in the given tag");
        }
        if (!tag.contains("channel", 3)) {
            throw new IllegalArgumentException("Could not find a channel entry in the given tag");
        }
        I id = handler.deserializeCraftingJobId(tag.get("id"));
        ListTag dependenciesTag = tag.getList("dependencies", 10);
        ArrayList dependencies = Lists.newArrayListWithExpectedSize((int)dependenciesTag.size());
        for (Tag nbtBase : dependenciesTag) {
            dependencies.add(TerminalCraftingPlanStatic.deserialize(lookupProvider, (CompoundTag)nbtBase, handler));
        }
        ListTag outputsTag = tag.getList("outputs", 10);
        ArrayList outputs = Lists.newArrayListWithExpectedSize((int)outputsTag.size());
        for (Tag nbtBase : outputsTag) {
            outputs.add(IPrototypedIngredient.deserialize((HolderLookup.Provider)lookupProvider, (CompoundTag)((CompoundTag)nbtBase)));
        }
        TerminalCraftingJobStatus status = TerminalCraftingJobStatus.values()[tag.getInt("status")];
        long craftingQuantity = tag.getLong("craftingQuantity");
        ListTag bufferedIngredientsTag = tag.getList("bufferedIngredients", 10);
        ArrayList bufferedIngredients = Lists.newArrayListWithExpectedSize((int)bufferedIngredientsTag.size());
        for (Tag nbtBase : bufferedIngredientsTag) {
            bufferedIngredients.add(IPrototypedIngredient.deserialize((HolderLookup.Provider)lookupProvider, (CompoundTag)((CompoundTag)nbtBase)));
        }
        ListTag lastMissingIngredientsTag = tag.getList("lastMissingIngredients", 9);
        ArrayList lastMissingIngredients = Lists.newArrayListWithExpectedSize((int)lastMissingIngredientsTag.size());
        for (Tag nbtBase : lastMissingIngredientsTag) {
            ListTag list = (ListTag)nbtBase;
            ArrayList lastMissingIngredient = Lists.newArrayListWithExpectedSize((int)list.size());
            for (Tag base : list) {
                lastMissingIngredient.add(IPrototypedIngredient.deserialize((HolderLookup.Provider)lookupProvider, (CompoundTag)((CompoundTag)base)));
            }
            lastMissingIngredients.add(lastMissingIngredient);
        }
        Label label = Label.values()[tag.getInt("label")];
        String unlocalizedLabelOverride = null;
        if (tag.contains("unlocalizedLabelOverride")) {
            unlocalizedLabelOverride = tag.getString("unlocalizedLabelOverride");
        }
        long tickDuration = tag.getLong("tickDuration");
        int channel = tag.getInt("channel");
        String initiatorName = null;
        if (tag.contains("initiatorName", 8)) {
            initiatorName = tag.getString("initiatorName");
        }
        TerminalCraftingPlanStatic<I> plan = new TerminalCraftingPlanStatic<I>(id, dependencies, outputs, status, craftingQuantity, bufferedIngredients, lastMissingIngredients, label, tickDuration, channel, initiatorName);
        if (unlocalizedLabelOverride != null) {
            plan.unlocalizedLabelOverride = unlocalizedLabelOverride;
        }
        return plan;
    }

    public static enum Label {
        RUNNING("gui.integratedterminals.terminal_storage.craftingplan.label.running"),
        VALID("gui.integratedterminals.terminal_storage.craftingplan.label.valid"),
        INCOMPLETE("gui.integratedterminals.terminal_storage.craftingplan.label.failed.incomplete"),
        RECURSION("gui.integratedterminals.terminal_storage.craftingplan.label.failed.recursion"),
        ERROR("ERROR");

        private final String unlocalizedMessage;

        private Label(String unlocalizedMessage) {
            this.unlocalizedMessage = unlocalizedMessage;
        }

        public String getUnlocalizedMessage() {
            return this.unlocalizedMessage;
        }
    }

    public static class IndexedEntries {
        private final Map<IPrototypedIngredient<?, ?>, TerminalCraftingPlanFlatStatic.Entry> indexedEntries = Maps.newHashMap();

        public TerminalCraftingPlanFlatStatic.Entry get(IPrototypedIngredient<?, ?> prototypedIngredient) {
            IPrototypedIngredient<?, ?> prototype = this.getPrototype(prototypedIngredient);
            return this.indexedEntries.computeIfAbsent(prototype, k -> new TerminalCraftingPlanFlatStatic.Entry((IPrototypedIngredient<?, ?>)new PrototypedIngredient(prototypedIngredient.getComponent(), prototype.getPrototype(), prototypedIngredient.getCondition())));
        }

        protected <T, M> IPrototypedIngredient<T, M> getPrototype(IPrototypedIngredient<T, M> prototypedIngredient) {
            IIngredientMatcher matcher = prototypedIngredient.getComponent().getMatcher();
            return new PrototypedIngredient(prototypedIngredient.getComponent(), matcher.withQuantity(prototypedIngredient.getPrototype(), 1L), matcher.getExactMatchNoQuantityCondition());
        }

        public static long getQuantity(IPrototypedIngredient<?, ?> prototypedIngredient) {
            IIngredientMatcher matcher = prototypedIngredient.getComponent().getMatcher();
            return matcher.getQuantity(prototypedIngredient.getPrototype());
        }

        public Collection<TerminalCraftingPlanFlatStatic.Entry> getEntries() {
            return this.indexedEntries.values();
        }
    }
}

