/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.util;

import com.jerry.mekaf.common.block.attribute.AttributeAdvancedFactoryType;
import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.common.block.attribute.MoreMachineAttributeFactoryType;
import com.jerry.mekmm.common.util.MoreMachineEnumUtils;
import java.util.Arrays;
import mekanism.api.text.EnumColor;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tier.FactoryTier;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class MoreMachineUtils {
    public static Component formatDim(ResourceLocation id) {
        return Component.translatableWithFallback((String)id.toLanguageKey("dimension"), (String)id.toString());
    }

    public static String formatPos(BlockPos pos) {
        return "[" + pos.getX() + "," + pos.getY() + "," + pos.getZ() + "]";
    }

    public static EnumColor getColorByTransmitterType(TransmissionType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case TransmissionType.ENERGY -> EnumColor.BRIGHT_GREEN;
            case TransmissionType.FLUID -> EnumColor.AQUA;
            case TransmissionType.CHEMICAL -> EnumColor.YELLOW;
            case TransmissionType.ITEM -> EnumColor.GRAY;
            case TransmissionType.HEAT -> EnumColor.ORANGE;
        };
    }

    public static FactoryTier[] getFactoryTier() {
        if (Mekmm.hooks.evolvedMekanism.isLoaded()) {
            FactoryTier[] mergedTiers = Arrays.copyOf(EnumUtils.FACTORY_TIERS, EnumUtils.FACTORY_TIERS.length + MoreMachineEnumUtils.EM_TIERS.length);
            System.arraycopy(MoreMachineEnumUtils.EM_TIERS, 0, mergedTiers, EnumUtils.FACTORY_TIERS.length, MoreMachineEnumUtils.EM_TIERS.length);
            return mergedTiers;
        }
        return EnumUtils.FACTORY_TIERS;
    }

    public static boolean isSameMMTypeFactory(Holder<Block> block, Block factoryBlockType) {
        MoreMachineAttributeFactoryType attribute = (MoreMachineAttributeFactoryType)Attribute.get(block, MoreMachineAttributeFactoryType.class);
        if (attribute != null) {
            MoreMachineAttributeFactoryType otherType = (MoreMachineAttributeFactoryType)Attribute.get((Block)factoryBlockType, MoreMachineAttributeFactoryType.class);
            return otherType != null && attribute.getMoreMachineFactoryType() == otherType.getMoreMachineFactoryType();
        }
        return false;
    }

    public static boolean isSameAFTypeFactory(Holder<Block> block, Block factoryBlockType) {
        AttributeAdvancedFactoryType attribute = (AttributeAdvancedFactoryType)Attribute.get(block, AttributeAdvancedFactoryType.class);
        if (attribute != null) {
            AttributeAdvancedFactoryType otherType = (AttributeAdvancedFactoryType)Attribute.get((Block)factoryBlockType, AttributeAdvancedFactoryType.class);
            return otherType != null && attribute.getAdvancedFactoryType() == otherType.getAdvancedFactoryType();
        }
        return false;
    }
}

