/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.machine;

import com.jerry.mekmm.api.recipes.basic.BasicFluidChemicalToFluidRecipe;
import com.jerry.mekmm.api.recipes.cache.ReplicatorCachedRecipe;
import com.jerry.mekmm.client.recipe_viewer.MMRecipeViewerRecipeType;
import com.jerry.mekmm.common.config.MoreMachineConfig;
import com.jerry.mekmm.common.recipe.impl.FluidReplicatorIRecipeSingle;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.registries.MoreMachineChemicals;
import com.jerry.mekmm.common.util.MoreMachineUtils;
import com.jerry.mekmm.common.util.ValidatorUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.FluidSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityFluidReplicator
extends TileEntityProgressMachine<BasicFluidChemicalToFluidRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    public static final int MAX_FLUID = 10000;
    public static final long MAX_GAS = 10000L;
    private static final int BASE_TICKS_REQUIRED = 200;
    public static HashMap<String, Integer> customRecipeMap = ValidatorUtils.getRecipeFromConfig((List)MoreMachineConfig.general.fluidReplicatorRecipe.get());
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getInput", "getInputCapacity", "getInputNeeded", "getInputFilledPercentage"}, docPlaceholder="input tank")
    public BasicFluidTank inputTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getOutput", "getOutputCapacity", "getOutputNeeded", "getOutputFilledPercentage"}, docPlaceholder="output tank")
    public BasicFluidTank outputTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getUU", "getUUCapacity", "getUUNeeded", "getUUFilledPercentage"}, docPlaceholder="uu tank")
    public IChemicalTank uuTank;
    private MachineEnergyContainer<TileEntityFluidReplicator> energyContainer;
    private final IInputHandler<@NotNull FluidStack> fluidInputHandler;
    private final IOutputHandler<@NotNull FluidStack> fluidOutputHandler;
    private final ILongInputHandler<ChemicalStack> chemicalInputHandler;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputTankOutputSlot"}, docPlaceholder="input tank output slot")
    FluidInventorySlot inputTankOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputTankOutputSlot"}, docPlaceholder="output tank output slot")
    FluidInventorySlot outputTankOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputSlot"}, docPlaceholder="input slot")
    FluidInventorySlot fluidInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputSlot"}, docPlaceholder="output slot")
    OutputInventorySlot fluidOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getUUSlot"}, docPlaceholder="uu slot")
    ChemicalInventorySlot uuSlot;
    EnergyInventorySlot energySlot;

    public TileEntityFluidReplicator(BlockPos pos, BlockState state) {
        super(MoreMachineBlocks.FLUID_REPLICATOR, pos, state, TRACKED_ERROR_TYPES, 200);
        ConfigInfo fluidConfig;
        this.configComponent.setupItemIOConfig(List.of(this.fluidInputSlot, this.inputTankOutputSlot), List.of(this.outputTankOutputSlot, this.fluidOutputSlot), (IInventorySlot)this.energySlot, false);
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.EXTRA, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.uuSlot}));
        }
        if ((fluidConfig = this.configComponent.getConfig(TransmissionType.FLUID)) != null) {
            fluidConfig.addSlotInfo(DataType.INPUT, (ISlotInfo)new FluidSlotInfo(true, false, new IExtendedFluidTank[]{this.inputTank}));
            fluidConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new FluidSlotInfo(false, true, new IExtendedFluidTank[]{this.outputTank}));
        }
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.configComponent.setupInputConfig(TransmissionType.CHEMICAL, (Object)this.uuTank);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.FLUID, TransmissionType.ITEM}).setCanTankEject(tank -> tank == this.outputTank);
        this.fluidInputHandler = InputHelper.getInputHandler((IExtendedFluidTank)this.inputTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.fluidOutputHandler = OutputHelper.getOutputHandler((IExtendedFluidTank)this.outputTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
        this.chemicalInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.uuTank);
    }

    @Nullable
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.inputTank = BasicFluidTank.input((int)1000, TileEntityFluidReplicator::isValidFluidInput, (IContentsListener)recipeCacheListener);
        builder.addTank((IExtendedFluidTank)this.inputTank);
        this.outputTank = BasicFluidTank.output((int)10000, (IContentsListener)recipeCacheUnpauseListener);
        builder.addTank((IExtendedFluidTank)this.outputTank);
        return builder.build();
    }

    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.uuTank = BasicChemicalTank.inputModern((long)10000L, TileEntityFluidReplicator::isValidChemicalInput, (IContentsListener)recipeCacheListener);
        builder.addTank(this.uuTank);
        return builder.build();
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig((ISideConfiguration)this);
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)recipeCacheUnpauseListener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig((ISideConfiguration)this);
        this.fluidInputSlot = FluidInventorySlot.fill((IExtendedFluidTank)this.inputTank, (IContentsListener)listener, (int)180, (int)71);
        builder.addSlot((IInventorySlot)this.fluidInputSlot);
        this.fluidOutputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)180, (int)102);
        builder.addSlot((IInventorySlot)this.fluidOutputSlot);
        this.inputTankOutputSlot = FluidInventorySlot.drain((IExtendedFluidTank)this.inputTank, (IContentsListener)listener, (int)29, (int)65);
        builder.addSlot((IInventorySlot)this.inputTankOutputSlot);
        this.outputTankOutputSlot = FluidInventorySlot.drain((IExtendedFluidTank)this.outputTank, (IContentsListener)listener, (int)132, (int)65);
        builder.addSlot((IInventorySlot)this.outputTankOutputSlot);
        this.uuSlot = ChemicalInventorySlot.fillOrConvert((IChemicalTank)this.uuTank, () -> ((TileEntityFluidReplicator)this).getLevel(), (IContentsListener)listener, (int)8, (int)65);
        builder.addSlot((IInventorySlot)this.uuSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityFluidReplicator)this).getLevel(), (IContentsListener)listener, (int)152, (int)65);
        builder.addSlot((IInventorySlot)this.energySlot);
        this.uuSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.fluidInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.inputTankOutputSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.outputTankOutputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    public static boolean isValidFluidInput(FluidStack stack) {
        if (customRecipeMap != null) {
            return customRecipeMap.containsKey(Objects.requireNonNull(RegistryUtils.getName((Holder)stack.getFluidHolder())).toString());
        }
        return false;
    }

    public static boolean isValidChemicalInput(ChemicalStack stack) {
        return stack.is(MoreMachineChemicals.UU_MATTER);
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.fluidInputSlot.fillTank((IInventorySlot)this.fluidOutputSlot);
        this.uuSlot.fillTankOrConvert();
        this.inputTankOutputSlot.drainTank((IInventorySlot)this.fluidOutputSlot);
        this.outputTankOutputSlot.drainTank((IInventorySlot)this.fluidOutputSlot);
        this.recipeCacheLookupMonitor.updateAndProcess();
        return sendUpdatePacket;
    }

    @Nullable
    public MachineEnergyContainer<TileEntityFluidReplicator> getEnergyContainer() {
        return this.energyContainer;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<?, BasicFluidChemicalToFluidRecipe, ?> getRecipeType() {
        return null;
    }

    @Nullable
    public BasicFluidChemicalToFluidRecipe getRecipe(int cacheIndex) {
        return TileEntityFluidReplicator.getRecipe((FluidStack)this.fluidInputHandler.getInput(), (ChemicalStack)this.chemicalInputHandler.getInput());
    }

    @NotNull
    public CachedRecipe<BasicFluidChemicalToFluidRecipe> createNewCachedRecipe(@NotNull BasicFluidChemicalToFluidRecipe recipe, int cacheIndex) {
        return ReplicatorCachedRecipe.createFluidReplicator(recipe, this.recheckAllRecipeErrors, this.fluidInputHandler, this.chemicalInputHandler, this.fluidOutputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set)x$0)).setCanHolderFunction(() -> ((TileEntityFluidReplicator)this).canFunction()).setActive(arg_0 -> ((TileEntityFluidReplicator)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setRequiredTicks(() -> ((TileEntityFluidReplicator)this).getTicksRequired()).setOnFinish(() -> ((TileEntityFluidReplicator)this).markForSave()).setOperatingTicksChanged(x$0 -> this.setOperatingTicks(x$0)).setBaselineMaxOperations(() -> ((TileEntityFluidReplicator)this).getOperationsPerTick());
    }

    @Nullable
    public IRecipeViewerRecipeType<BasicFluidChemicalToFluidRecipe> recipeViewerType() {
        return MMRecipeViewerRecipeType.FLUID_REPLICATOR;
    }

    public static BasicFluidChemicalToFluidRecipe getRecipe(FluidStack fluidStack, ChemicalStack chemicalStack) {
        if (chemicalStack.isEmpty() || fluidStack.isEmpty()) {
            return null;
        }
        if (customRecipeMap != null) {
            Holder fluidHolder = fluidStack.getFluidHolder();
            int amount = customRecipeMap.getOrDefault(Objects.requireNonNull(RegistryUtils.getName((Holder)fluidHolder)).toString(), 0);
            if (amount == 0) {
                return null;
            }
            return new FluidReplicatorIRecipeSingle(IngredientCreatorAccess.fluid().fromHolder(fluidHolder, 1000), IngredientCreatorAccess.chemicalStack().fromHolder(MoreMachineChemicals.UU_MATTER, amount), new FluidStack(fluidHolder, 1000));
        }
        return null;
    }

    public boolean isConfigurationDataCompatible(Block type) {
        return super.isConfigurationDataCompatible(type) || MoreMachineUtils.isSameMMTypeFactory((Holder<Block>)this.getBlockHolder(), type);
    }

    @ComputerMethod(methodDescription="Get the energy used in the last tick by the machine")
    long getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : 0L;
    }
}

