/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.machine;

import com.jerry.mekmm.common.config.MoreMachineConfig;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.registries.MoreMachineChemicals;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityAmbientGasCollector
extends TileEntityMekanism {
    private static final int BASE_TICKS_REQUIRED = 19;
    public static final int MAX_CHEMICAL = 10000;
    private static final int BASE_OUTPUT_RATE = 256;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getChemical", "getChemicalCapacity", "getChemicalNeeded", "getChemicalFilledPercentage"}, docPlaceholder="chemical tank")
    public IChemicalTank chemicalTank;
    public int ticksRequired = 19;
    public int operatingTicks;
    private boolean usedEnergy = false;
    private int outputRate = 256;
    private boolean noBlocking = true;
    private List<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> chemicalHandlerAbove = Collections.emptyList();
    private MachineEnergyContainer<TileEntityAmbientGasCollector> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getChemicalItem"}, docPlaceholder="chemical slot")
    ChemicalInventorySlot chemicalSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityAmbientGasCollector(BlockPos pos, BlockState state) {
        super(MoreMachineBlocks.AMBIENT_GAS_COLLECTOR, pos, state);
    }

    @Nullable
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSide((Supplier)this.facingSupplier);
        this.chemicalTank = BasicChemicalTank.output((long)10000L, (IContentsListener)listener);
        builder.addTank(this.chemicalTank, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.FRONT, RelativeSide.BACK});
        return builder.build();
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide((Supplier)this.facingSupplier);
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer, new RelativeSide[]{RelativeSide.BOTTOM, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.FRONT, RelativeSide.BACK});
        return builder.build();
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide((Supplier)this.facingSupplier);
        this.chemicalSlot = ChemicalInventorySlot.drain((IChemicalTank)this.chemicalTank, (IContentsListener)listener, (int)28, (int)35);
        builder.addSlot((IInventorySlot)this.chemicalSlot, new RelativeSide[]{RelativeSide.BOTTOM, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.FRONT, RelativeSide.BACK});
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityAmbientGasCollector)this).getLevel(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.BOTTOM, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.FRONT, RelativeSide.BACK});
        this.chemicalSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    protected boolean onUpdateServer() {
        long energyPerTick;
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.chemicalSlot.drainTank();
        long clientEnergyUsed = 0L;
        if (this.canFunction() && (this.chemicalTank.isEmpty() || (long)this.estimateIncrementAmount() <= this.chemicalTank.getNeeded()) && this.energyContainer.extract(energyPerTick = this.energyContainer.getEnergyPerTick(), Action.SIMULATE, AutomationType.INTERNAL) == energyPerTick) {
            ++this.operatingTicks;
            if (this.operatingTicks >= this.ticksRequired) {
                this.operatingTicks = 0;
                if (this.suck(this.worldPosition.relative(Direction.UP))) {
                    clientEnergyUsed = this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                }
            }
        }
        boolean bl = this.usedEnergy = clientEnergyUsed > 0L;
        if (!this.chemicalTank.isEmpty()) {
            if (this.chemicalHandlerAbove.isEmpty()) {
                this.chemicalHandlerAbove = List.of(Capabilities.CHEMICAL.createCache((ServerLevel)this.level, this.worldPosition.north(), Direction.UP));
            }
            ChemicalUtil.emit(this.chemicalHandlerAbove, (IChemicalTank)this.chemicalTank, (long)this.outputRate);
        }
        return sendUpdatePacket;
    }

    public int estimateIncrementAmount() {
        return MoreMachineConfig.general.gasCollectAmount.get();
    }

    private boolean suck(BlockPos pos) {
        BlockState blockState;
        Block block;
        Optional state = WorldUtils.getBlockState((BlockGetter)this.level, (BlockPos)pos);
        if (state.isPresent() && this.isAir(block = (blockState = (BlockState)state.get()).getBlock())) {
            ChemicalStack chemicalStack = new ChemicalStack(MoreMachineChemicals.UNSTABLE_DIMENSIONAL_GAS, (long)this.estimateIncrementAmount());
            this.chemicalTank.insert(chemicalStack, Action.EXECUTE, AutomationType.INTERNAL);
            return true;
        }
        return false;
    }

    public boolean isAir(Block block) {
        this.noBlocking = block == Blocks.AIR;
        return this.noBlocking;
    }

    public boolean getNotBlocking() {
        return this.noBlocking;
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.operatingTicks = nbt.getInt("progress");
    }

    public boolean supportsMode(IRedstoneControl.RedstoneControl mode) {
        return true;
    }

    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks((IUpgradeTile)this, (int)19);
            this.outputRate = 256 * (1 + this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        }
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.chemicalTank.getStored(), (long)this.chemicalTank.getCapacity());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.CHEMICAL;
    }

    @NotNull
    public List<Component> getInfo(@NotNull Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo((IUpgradeTile)this, (Upgrade)upgrade);
    }

    public boolean usedEnergy() {
        return this.usedEnergy;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableBoolean.create(this::usedEnergy, value -> {
            this.usedEnergy = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::getNotBlocking, value -> {
            this.noBlocking = value;
        }));
    }

    @Generated
    public MachineEnergyContainer<TileEntityAmbientGasCollector> getEnergyContainer() {
        return this.energyContainer;
    }
}

