/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekmm.common.block.prefab.MMBlockFactoryMachine;
import com.jerry.mekmm.common.content.blocktype.MoreMachineFactoryType;
import com.jerry.mekmm.common.item.block.machine.ItemBlockMoreMachineFactory;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.tile.TileEntityAuthorDoll;
import com.jerry.mekmm.common.tile.TileEntityModelerDoll;
import com.jerry.mekmm.common.tile.factory.TileEntityMoreMachineFactory;
import com.jerry.mekmm.common.tile.factory.TileEntityMoreMachineItemStackToItemStackFactory;
import com.jerry.mekmm.common.tile.factory.TileEntityPlantingFactory;
import com.jerry.mekmm.common.tile.factory.TileEntityRecyclingFactory;
import com.jerry.mekmm.common.tile.factory.TileEntityReplicatingFactory;
import com.jerry.mekmm.common.tile.factory.TileEntityStampingFactory;
import com.jerry.mekmm.common.tile.machine.TileEntityAmbientGasCollector;
import com.jerry.mekmm.common.tile.machine.TileEntityChemicalReplicator;
import com.jerry.mekmm.common.tile.machine.TileEntityFluidReplicator;
import com.jerry.mekmm.common.tile.machine.TileEntityLathe;
import com.jerry.mekmm.common.tile.machine.TileEntityPlantingStation;
import com.jerry.mekmm.common.tile.machine.TileEntityRecycler;
import com.jerry.mekmm.common.tile.machine.TileEntityReplicator;
import com.jerry.mekmm.common.tile.machine.TileEntityRollingMill;
import com.jerry.mekmm.common.tile.machine.TileEntityStamper;
import com.jerry.mekmm.common.tile.machine.TileEntityWirelessChargingStation;
import com.jerry.mekmm.common.tile.machine.TileEntityWirelessTransmissionStation;
import com.jerry.mekmm.common.util.MoreMachineUtils;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeDeferredRegister;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MoreMachineTileEntityTypes {
    public static final TileEntityTypeDeferredRegister MM_TILE_ENTITY_TYPES = new TileEntityTypeDeferredRegister("mekmm");
    private static final Table<FactoryTier, MoreMachineFactoryType, TileEntityTypeRegistryObject<? extends TileEntityMoreMachineFactory<?>>> MM_FACTORIES = HashBasedTable.create();
    public static final TileEntityTypeRegistryObject<TileEntityRecycler> RECYCLER;
    public static final TileEntityTypeRegistryObject<TileEntityPlantingStation> PLANTING_STATION;
    public static final TileEntityTypeRegistryObject<TileEntityStamper> CNC_STAMPER;
    public static final TileEntityTypeRegistryObject<TileEntityLathe> CNC_LATHE;
    public static final TileEntityTypeRegistryObject<TileEntityRollingMill> CNC_ROLLING_MILL;
    public static final TileEntityTypeRegistryObject<TileEntityReplicator> REPLICATOR;
    public static final TileEntityTypeRegistryObject<TileEntityFluidReplicator> FLUID_REPLICATOR;
    public static final TileEntityTypeRegistryObject<TileEntityChemicalReplicator> CHEMICAL_REPLICATOR;
    public static final TileEntityTypeRegistryObject<TileEntityAmbientGasCollector> AMBIENT_GAS_COLLECTOR;
    public static final TileEntityTypeRegistryObject<TileEntityWirelessChargingStation> WIRELESS_CHARGING_STATION;
    public static final TileEntityTypeRegistryObject<TileEntityWirelessTransmissionStation> WIRELESS_TRANSMISSION_STATION;
    public static final TileEntityTypeRegistryObject<TileEntityAuthorDoll> AUTHOR_DOLL;
    public static final TileEntityTypeRegistryObject<TileEntityModelerDoll> MODELER_DOLL;

    private MoreMachineTileEntityTypes() {
    }

    private static void registerFactory(FactoryTier tier, MoreMachineFactoryType type, MMBlockEntityFactory<? extends TileEntityMoreMachineFactory<?>> factoryConstructor) {
        BlockRegistryObject<MMBlockFactoryMachine.BlockMoreMachineFactory<?>, ItemBlockMoreMachineFactory> block = MoreMachineBlocks.getMoreMachineFactory(tier, type);
        TileEntityTypeRegistryObject tileRO = MM_TILE_ENTITY_TYPES.mekBuilder(block, (pos, state) -> (TileEntityMoreMachineFactory)((Object)((Object)factoryConstructor.create((Holder<Block>)block, pos, state)))).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        MM_FACTORIES.put((Object)tier, (Object)type, (Object)tileRO);
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityMoreMachineFactory<?>> getMoreMachineFactoryTile(FactoryTier tier, MoreMachineFactoryType type) {
        return (TileEntityTypeRegistryObject)MM_FACTORIES.get((Object)tier, (Object)type);
    }

    public static TileEntityTypeRegistryObject<? extends TileEntityMoreMachineFactory<?>>[] getMoreMachineFactoryTiles() {
        return MM_FACTORIES.values().toArray(new TileEntityTypeRegistryObject[0]);
    }

    static {
        for (FactoryTier tier : MoreMachineUtils.getFactoryTier()) {
            MoreMachineTileEntityTypes.registerFactory(tier, MoreMachineFactoryType.RECYCLING, TileEntityRecyclingFactory::new);
            MoreMachineTileEntityTypes.registerFactory(tier, MoreMachineFactoryType.PLANTING_STATION, TileEntityPlantingFactory::new);
            MoreMachineTileEntityTypes.registerFactory(tier, MoreMachineFactoryType.CNC_STAMPING, TileEntityStampingFactory::new);
            MoreMachineTileEntityTypes.registerFactory(tier, MoreMachineFactoryType.CNC_LATHING, TileEntityMoreMachineItemStackToItemStackFactory::new);
            MoreMachineTileEntityTypes.registerFactory(tier, MoreMachineFactoryType.CNC_ROLLING_MILL, TileEntityMoreMachineItemStackToItemStackFactory::new);
            MoreMachineTileEntityTypes.registerFactory(tier, MoreMachineFactoryType.REPLICATING, TileEntityReplicatingFactory::new);
        }
        RECYCLER = MM_TILE_ENTITY_TYPES.mekBuilder(MoreMachineBlocks.RECYCLER, TileEntityRecycler::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        PLANTING_STATION = MM_TILE_ENTITY_TYPES.mekBuilder(MoreMachineBlocks.PLANTING_STATION, TileEntityPlantingStation::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        CNC_STAMPER = MM_TILE_ENTITY_TYPES.mekBuilder(MoreMachineBlocks.CNC_STAMPER, TileEntityStamper::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        CNC_LATHE = MM_TILE_ENTITY_TYPES.mekBuilder(MoreMachineBlocks.CNC_LATHE, TileEntityLathe::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        CNC_ROLLING_MILL = MM_TILE_ENTITY_TYPES.mekBuilder(MoreMachineBlocks.CNC_ROLLING_MILL, TileEntityRollingMill::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        REPLICATOR = MM_TILE_ENTITY_TYPES.mekBuilder(MoreMachineBlocks.REPLICATOR, TileEntityReplicator::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        FLUID_REPLICATOR = MM_TILE_ENTITY_TYPES.mekBuilder(MoreMachineBlocks.FLUID_REPLICATOR, TileEntityFluidReplicator::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        CHEMICAL_REPLICATOR = MM_TILE_ENTITY_TYPES.mekBuilder(MoreMachineBlocks.CHEMICAL_REPLICATOR, TileEntityChemicalReplicator::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        AMBIENT_GAS_COLLECTOR = MM_TILE_ENTITY_TYPES.mekBuilder(MoreMachineBlocks.AMBIENT_GAS_COLLECTOR, TileEntityAmbientGasCollector::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).build();
        WIRELESS_CHARGING_STATION = MM_TILE_ENTITY_TYPES.mekBuilder(MoreMachineBlocks.WIRELESS_CHARGING_STATION, TileEntityWirelessChargingStation::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).withSimple(Capabilities.CONFIGURABLE).build();
        WIRELESS_TRANSMISSION_STATION = MM_TILE_ENTITY_TYPES.mekBuilder(MoreMachineBlocks.WIRELESS_TRANSMISSION_STATION, TileEntityWirelessTransmissionStation::new).clientTicker(TileEntityMekanism::tickClient).serverTicker(TileEntityMekanism::tickServer).withSimple(Capabilities.CONFIG_CARD).withSimple(Capabilities.CONFIGURABLE).build();
        AUTHOR_DOLL = MM_TILE_ENTITY_TYPES.builder(MoreMachineBlocks.AUTHOR_DOLL, TileEntityAuthorDoll::new).build();
        MODELER_DOLL = MM_TILE_ENTITY_TYPES.builder(MoreMachineBlocks.MODELER_DOLL, TileEntityModelerDoll::new).build();
    }

    @FunctionalInterface
    private static interface MMBlockEntityFactory<BE extends BlockEntity> {
        public BE create(Holder<Block> var1, BlockPos var2, BlockState var3);
    }
}

