/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.recipe.serializer;

import com.jerry.mekmm.api.recipes.PlantingRecipe;
import com.jerry.mekmm.api.recipes.basic.BasicPlantingRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function6;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

@NothingNullByDefault
public class PlantingRecipeSerializer
implements RecipeSerializer<BasicPlantingRecipe> {
    private final StreamCodec<RegistryFriendlyByteBuf, BasicPlantingRecipe> streamCodec;
    private final MapCodec<BasicPlantingRecipe> codec;

    public PlantingRecipeSerializer(Function6<ItemStackIngredient, ChemicalStackIngredient, ItemStack, ItemStack, Double, Boolean, BasicPlantingRecipe> factory) {
        Codec chanceCodec = Codec.DOUBLE.validate(d -> d > 0.0 && d <= 1.0 ? DataResult.success((Object)d) : DataResult.error(() -> "Expected secondaryChance to be greater than zero, and less than or equal to one. Found " + d));
        MapCodec secondaryChanceFieldBase = chanceCodec.optionalFieldOf("secondary_chance");
        MapCodec mainOutputFieldBase = ItemStack.CODEC.optionalFieldOf("main_output");
        RecordCodecBuilder secondaryOutputField = ItemStack.CODEC.optionalFieldOf("secondary_output").forGetter(BasicPlantingRecipe::getSecondaryOutputRaw);
        this.codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStackIngredient.CODEC.fieldOf("item_input").forGetter(PlantingRecipe::getItemInput), (App)IngredientCreatorAccess.chemicalStack().codec().fieldOf("chemical_input").forGetter(PlantingRecipe::getChemicalInput), (App)SerializerHelper.oneRequired((RecordCodecBuilder)secondaryOutputField, (MapCodec)mainOutputFieldBase, BasicPlantingRecipe::getMainOutputRaw), (App)secondaryOutputField, (App)SerializerHelper.dependentOptionality((RecordCodecBuilder)secondaryOutputField, (MapCodec)secondaryChanceFieldBase, plantingRecipe -> {
            double secondaryChance = plantingRecipe.getSecondaryChance();
            return secondaryChance == 0.0 ? Optional.empty() : Optional.of(secondaryChance);
        }), (App)Codec.BOOL.fieldOf("per_tick_usage").forGetter(BasicPlantingRecipe::perTickUsage)).apply((Applicative)instance, (itemInput, chemicalInput, mainOutput, secondaryOutput, secondChance, perTickUsage) -> (BasicPlantingRecipe)factory.apply(itemInput, chemicalInput, (Object)mainOutput.orElse(ItemStack.EMPTY), (Object)secondaryOutput.orElse(ItemStack.EMPTY), (Object)secondChance.orElse(0.0), perTickUsage)));
        this.streamCodec = StreamCodec.composite((StreamCodec)ItemStackIngredient.STREAM_CODEC, PlantingRecipe::getItemInput, (StreamCodec)IngredientCreatorAccess.chemicalStack().streamCodec(), PlantingRecipe::getChemicalInput, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, recipe -> recipe.getMainOutputRaw().orElse(ItemStack.EMPTY), (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, recipe -> recipe.getSecondaryOutputRaw().orElse(ItemStack.EMPTY), (StreamCodec)ByteBufCodecs.DOUBLE, PlantingRecipe::getSecondaryChance, (StreamCodec)ByteBufCodecs.BOOL, BasicPlantingRecipe::perTickUsage, factory);
    }

    public MapCodec<BasicPlantingRecipe> codec() {
        return this.codec;
    }

    public StreamCodec<RegistryFriendlyByteBuf, BasicPlantingRecipe> streamCodec() {
        return this.streamCodec;
    }
}

