/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.network.to_server;

import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.common.tile.machine.TileEntityWirelessTransmissionStation;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import java.util.function.ObjLongConsumer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketGuiSetLongValue(GuiLongValue interaction, BlockPos pos, long value) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketGuiSetLongValue> TYPE = new CustomPacketPayload.Type(Mekmm.rl("set_long_value"));
    public static final StreamCodec<ByteBuf, PacketGuiSetLongValue> STREAM_CODEC = StreamCodec.composite(GuiLongValue.STREAM_CODEC, PacketGuiSetLongValue::interaction, (StreamCodec)BlockPos.STREAM_CODEC, PacketGuiSetLongValue::pos, (StreamCodec)ByteBufCodecs.VAR_LONG, PacketGuiSetLongValue::value, PacketGuiSetLongValue::new);

    public void handle(IPayloadContext context) {
        BlockEntity blockEntity = PacketUtils.blockEntity((IPayloadContext)context, (BlockPos)this.pos);
        if (blockEntity instanceof TileEntityMekanism) {
            TileEntityMekanism tile = (TileEntityMekanism)blockEntity;
            this.interaction.consume(tile, this.value);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum GuiLongValue {
        SET_ENERGY_RATE((tile, value) -> {
            if (tile instanceof TileEntityWirelessTransmissionStation) {
                TileEntityWirelessTransmissionStation transmissionStation = (TileEntityWirelessTransmissionStation)tile;
                transmissionStation.setEnergyRateFromPacket(value);
            }
        }),
        SET_CHEMICALS_RATE((tile, value) -> {
            if (tile instanceof TileEntityWirelessTransmissionStation) {
                TileEntityWirelessTransmissionStation transmissionStation = (TileEntityWirelessTransmissionStation)tile;
                transmissionStation.setChemicalsRateFromPacket(value);
            }
        });

        public static final IntFunction<GuiLongValue> BY_ID;
        public static final StreamCodec<ByteBuf, GuiLongValue> STREAM_CODEC;
        private final ObjLongConsumer<TileEntityMekanism> consumerForTile;

        private GuiLongValue(ObjLongConsumer<TileEntityMekanism> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, long value) {
            this.consumerForTile.accept(tile, value);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])GuiLongValue.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

