/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.network.to_server;

import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.common.tile.machine.TileEntityWirelessTransmissionStation;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketGuiSetIntValue(GuiIntValue interaction, BlockPos pos, int value) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketGuiSetIntValue> TYPE = new CustomPacketPayload.Type(Mekmm.rl("set_int_value"));
    public static final StreamCodec<ByteBuf, PacketGuiSetIntValue> STREAM_CODEC = StreamCodec.composite(GuiIntValue.STREAM_CODEC, PacketGuiSetIntValue::interaction, (StreamCodec)BlockPos.STREAM_CODEC, PacketGuiSetIntValue::pos, (StreamCodec)ByteBufCodecs.VAR_INT, PacketGuiSetIntValue::value, PacketGuiSetIntValue::new);

    public void handle(IPayloadContext context) {
        BlockEntity blockEntity = PacketUtils.blockEntity((IPayloadContext)context, (BlockPos)this.pos);
        if (blockEntity instanceof TileEntityMekanism) {
            TileEntityMekanism tile = (TileEntityMekanism)blockEntity;
            this.interaction.consume(tile, this.value);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum GuiIntValue {
        SET_FLUIDS_RATE((tile, value) -> {
            if (tile instanceof TileEntityWirelessTransmissionStation) {
                TileEntityWirelessTransmissionStation transmissionStation = (TileEntityWirelessTransmissionStation)tile;
                transmissionStation.setFluidsRateFromPacket(value);
            }
        }),
        SET_ITEMS_RATE((tile, value) -> {
            if (tile instanceof TileEntityWirelessTransmissionStation) {
                TileEntityWirelessTransmissionStation transmissionStation = (TileEntityWirelessTransmissionStation)tile;
                transmissionStation.setItemsRateFromPacket(value);
            }
        });

        public static final IntFunction<GuiIntValue> BY_ID;
        public static final StreamCodec<ByteBuf, GuiIntValue> STREAM_CODEC;
        private final ObjIntConsumer<TileEntityMekanism> consumerForTile;

        private GuiIntValue(ObjIntConsumer<TileEntityMekanism> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, int value) {
            this.consumerForTile.accept(tile, value);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])GuiIntValue.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

