/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.network.to_server;

import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.common.tile.machine.TileEntityWirelessTransmissionStation;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import java.util.function.ObjDoubleConsumer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketGuiSetDoubleValue(GuiDoubleValue interaction, BlockPos pos, double value) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketGuiSetDoubleValue> TYPE = new CustomPacketPayload.Type(Mekmm.rl("set_double_value"));
    public static final StreamCodec<ByteBuf, PacketGuiSetDoubleValue> STREAM_CODEC = StreamCodec.composite(GuiDoubleValue.STREAM_CODEC, PacketGuiSetDoubleValue::interaction, (StreamCodec)BlockPos.STREAM_CODEC, PacketGuiSetDoubleValue::pos, (StreamCodec)ByteBufCodecs.DOUBLE, PacketGuiSetDoubleValue::value, PacketGuiSetDoubleValue::new);

    public void handle(IPayloadContext context) {
        BlockEntity blockEntity = PacketUtils.blockEntity((IPayloadContext)context, (BlockPos)this.pos);
        if (blockEntity instanceof TileEntityMekanism) {
            TileEntityMekanism tile = (TileEntityMekanism)blockEntity;
            this.interaction.consume(tile, this.value);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum GuiDoubleValue {
        SET_HEAT_RATE((tile, extra) -> {
            if (tile instanceof TileEntityWirelessTransmissionStation) {
                TileEntityWirelessTransmissionStation transmissionStation = (TileEntityWirelessTransmissionStation)tile;
                transmissionStation.setHeatRateFromPacket(extra);
            }
        });

        public static final IntFunction<GuiDoubleValue> BY_ID;
        public static final StreamCodec<ByteBuf, GuiDoubleValue> STREAM_CODEC;
        private final ObjDoubleConsumer<TileEntityMekanism> consumerForTile;

        private GuiDoubleValue(ObjDoubleConsumer<TileEntityMekanism> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, double value) {
            this.consumerForTile.accept(tile, value);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])GuiDoubleValue.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

