/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.network.to_server;

import com.jerry.mekaf.common.tile.factory.TileEntityAdvancedFactoryBase;
import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.common.tile.factory.TileEntityMoreMachineFactory;
import com.jerry.mekmm.common.tile.machine.TileEntityWirelessChargingStation;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import mekanism.api.functions.TriConsumer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class MoreMachinePacketGuiInteract
implements IMekanismPacket {
    public static final CustomPacketPayload.Type<MoreMachinePacketGuiInteract> TYPE = new CustomPacketPayload.Type(Mekmm.rl("gui_interact"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MoreMachinePacketGuiInteract> STREAM_CODEC = MoreMachineInteractionType.STREAM_CODEC.cast().dispatch(packet -> packet.interactionType, type -> switch (type.ordinal()) {
        default -> throw new MatchException(null, null);
        case 0 -> null;
        case 2 -> StreamCodec.composite(MoreMachineGuiInteraction.STREAM_CODEC, packet -> packet.interaction, (StreamCodec)BlockPos.STREAM_CODEC, packet -> packet.tilePosition, (StreamCodec)ByteBufCodecs.VAR_INT, packet -> packet.extra, MoreMachinePacketGuiInteract::new);
        case 1 -> StreamCodec.composite(MMGuiInteractionItem.STREAM_CODEC, packet -> packet.itemInteraction, (StreamCodec)BlockPos.STREAM_CODEC, packet -> packet.tilePosition, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, packet -> packet.extraItem, MoreMachinePacketGuiInteract::new);
    });
    private final MoreMachineInteractionType interactionType;
    private MoreMachineGuiInteraction interaction;
    private MMGuiInteractionItem itemInteraction;
    private BlockPos tilePosition;
    private ItemStack extraItem;
    private int entityID;
    private int extra;

    public MoreMachinePacketGuiInteract(MoreMachineGuiInteraction interaction, BlockEntity tile) {
        this(interaction, tile.getBlockPos());
    }

    public MoreMachinePacketGuiInteract(MoreMachineGuiInteraction interaction, BlockEntity tile, int extra) {
        this(interaction, tile.getBlockPos(), extra);
    }

    public MoreMachinePacketGuiInteract(MoreMachineGuiInteraction interaction, BlockPos tilePosition) {
        this(interaction, tilePosition, 0);
    }

    public MoreMachinePacketGuiInteract(MoreMachineGuiInteraction interaction, BlockPos tilePosition, int extra) {
        this.interactionType = MoreMachineInteractionType.INT;
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public MoreMachinePacketGuiInteract(MMGuiInteractionItem interaction, BlockEntity tile, ItemStack stack) {
        this(interaction, tile.getBlockPos(), stack);
    }

    public MoreMachinePacketGuiInteract(MMGuiInteractionItem interaction, BlockPos tilePosition, ItemStack stack) {
        this.interactionType = MoreMachineInteractionType.ITEM;
        this.itemInteraction = interaction;
        this.tilePosition = tilePosition;
        this.extraItem = stack;
    }

    public void handle(IPayloadContext context) {
        TileEntityMekanism tile;
        Player player = context.player();
        if (this.interactionType != MoreMachineInteractionType.ENTITY && (tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.level(), (BlockPos)this.tilePosition)) != null) {
            if (this.interactionType == MoreMachineInteractionType.INT) {
                this.interaction.consume(tile, player, this.extra);
            } else if (this.interactionType == MoreMachineInteractionType.ITEM) {
                this.itemInteraction.consume(tile, player, this.extraItem);
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<MoreMachinePacketGuiInteract> type() {
        return TYPE;
    }

    public static enum MoreMachineGuiInteraction {
        AUTO_SORT_BUTTON((TriConsumer<TileEntityMekanism, Player, Integer>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityMoreMachineFactory) {
                TileEntityMoreMachineFactory factory = (TileEntityMoreMachineFactory)((Object)tile);
                factory.toggleSorting();
            }
            if (tile instanceof TileEntityAdvancedFactoryBase) {
                TileEntityAdvancedFactoryBase advancedFactory = (TileEntityAdvancedFactoryBase)((Object)tile);
                advancedFactory.toggleSorting();
            }
        })),
        CHARGING_EQUIPS((TriConsumer<TileEntityMekanism, Player, Integer>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityWirelessChargingStation) {
                TileEntityWirelessChargingStation chargingStation = (TileEntityWirelessChargingStation)((Object)tile);
                chargingStation.toggleChargeEquipment();
            }
        })),
        CHARGING_INVENTORY((TriConsumer<TileEntityMekanism, Player, Integer>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityWirelessChargingStation) {
                TileEntityWirelessChargingStation chargingStation = (TileEntityWirelessChargingStation)((Object)tile);
                chargingStation.toggleChargeInventory();
            }
        })),
        CHARGING_CURIOS((TriConsumer<TileEntityMekanism, Player, Integer>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityWirelessChargingStation) {
                TileEntityWirelessChargingStation chargingStation = (TileEntityWirelessChargingStation)((Object)tile);
                chargingStation.toggleChargeCurios();
            }
        }));

        public static final IntFunction<MoreMachineGuiInteraction> BY_ID;
        public static final StreamCodec<ByteBuf, MoreMachineGuiInteraction> STREAM_CODEC;
        private final TriConsumer<TileEntityMekanism, Player, Integer> consumerForTile;

        private MoreMachineGuiInteraction(TriConsumer<TileEntityMekanism, Player, Integer> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, int extra) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)extra);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])MoreMachineGuiInteraction.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    private static enum MoreMachineInteractionType {
        ENTITY,
        ITEM,
        INT;

        public static final IntFunction<MoreMachineInteractionType> BY_ID;
        public static final StreamCodec<ByteBuf, MoreMachineInteractionType> STREAM_CODEC;

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])MoreMachineInteractionType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    public static final class MMGuiInteractionItem
    extends Enum<MMGuiInteractionItem> {
        public static final IntFunction<MMGuiInteractionItem> BY_ID;
        public static final StreamCodec<ByteBuf, MMGuiInteractionItem> STREAM_CODEC;
        private final TriConsumer<TileEntityMekanism, Player, ItemStack> consumerForTile;
        private static final /* synthetic */ MMGuiInteractionItem[] $VALUES;

        public static MMGuiInteractionItem[] values() {
            return (MMGuiInteractionItem[])$VALUES.clone();
        }

        public static MMGuiInteractionItem valueOf(String name) {
            return Enum.valueOf(MMGuiInteractionItem.class, name);
        }

        private MMGuiInteractionItem(TriConsumer<TileEntityMekanism, Player, ItemStack> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, ItemStack stack) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)stack);
        }

        private static /* synthetic */ MMGuiInteractionItem[] $values() {
            return new MMGuiInteractionItem[0];
        }

        static {
            $VALUES = MMGuiInteractionItem.$values();
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])MMGuiInteractionItem.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

