/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.attachments.component;

import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.common.attachments.component.ConnectionConfig;
import com.jerry.mekmm.common.tile.machine.TileEntityWirelessTransmissionStation;
import com.jerry.mekmm.common.tile.prefab.TileEntityConnectableMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.energy.BlockEnergyCapabilityCache;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class WirelessConnectionManager {
    private final TileEntityWirelessTransmissionStation tile;
    private final List<ConnectionConfig> connections = new ArrayList<ConnectionConfig>();
    private final Map<TransmissionType, List<Object>> capabilityCache = new EnumMap<TransmissionType, List<Object>>(TransmissionType.class);
    private boolean cacheDirty = true;

    public WirelessConnectionManager(TileEntityWirelessTransmissionStation tile) {
        this.tile = tile;
    }

    public TileEntityConnectableMachine.ConnectStatus linkOrCut(BlockPos pos, Direction direction, TransmissionType type) {
        ConnectionConfig config = new ConnectionConfig(pos, direction, type);
        if (this.connections.contains(config)) {
            this.connections.remove(config);
            this.cacheDirty = true;
            return TileEntityConnectableMachine.ConnectStatus.DISCONNECT;
        }
        if (this.validateCapability(pos, direction, type)) {
            this.connections.add(config);
            this.cacheDirty = true;
            return TileEntityConnectableMachine.ConnectStatus.CONNECT;
        }
        return TileEntityConnectableMachine.ConnectStatus.CONNECT_FAIL;
    }

    private boolean validateCapability(BlockPos pos, Direction direction, TransmissionType type) {
        if (this.tile.getLevel() == null || !this.tile.getLevel().isLoaded(pos)) {
            return false;
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case TransmissionType.ENERGY -> {
                if (WorldUtils.getCapability((Level)this.tile.getLevel(), (BlockCapability)Capabilities.ENERGY.block(), (BlockPos)pos, (Object)direction) != null) {
                    yield true;
                }
                yield false;
            }
            case TransmissionType.FLUID -> {
                if (WorldUtils.getCapability((Level)this.tile.getLevel(), (BlockCapability)Capabilities.FLUID.block(), (BlockPos)pos, (Object)direction) != null) {
                    yield true;
                }
                yield false;
            }
            case TransmissionType.CHEMICAL -> {
                if (WorldUtils.getCapability((Level)this.tile.getLevel(), (BlockCapability)Capabilities.CHEMICAL.block(), (BlockPos)pos, (Object)direction) != null) {
                    yield true;
                }
                yield false;
            }
            case TransmissionType.ITEM -> {
                if (WorldUtils.getCapability((Level)this.tile.getLevel(), (BlockCapability)Capabilities.ITEM.block(), (BlockPos)pos, (Object)direction) != null) {
                    yield true;
                }
                yield false;
            }
            case TransmissionType.HEAT -> WorldUtils.getCapability((Level)this.tile.getLevel(), (BlockCapability)Capabilities.HEAT, (BlockPos)pos, (Object)direction) != null;
        };
    }

    public Collection<BlockEnergyCapabilityCache> getEnergyCaches() {
        if (this.cacheDirty) {
            this.rebuildAllCaches();
        }
        List<BlockEnergyCapabilityCache> rawList = this.capabilityCache.getOrDefault(TransmissionType.ENERGY, Collections.emptyList());
        return rawList;
    }

    public Collection<BlockCapabilityCache<IFluidHandler, @Nullable Direction>> getFluidCaches() {
        if (this.cacheDirty) {
            this.rebuildAllCaches();
        }
        List<BlockCapabilityCache<IFluidHandler, Direction>> rawList = this.capabilityCache.getOrDefault(TransmissionType.FLUID, Collections.emptyList());
        return rawList;
    }

    public Collection<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> getChemicalCaches() {
        if (this.cacheDirty) {
            this.rebuildAllCaches();
        }
        List<BlockCapabilityCache<IChemicalHandler, Direction>> rawList = this.capabilityCache.getOrDefault(TransmissionType.CHEMICAL, Collections.emptyList());
        return rawList;
    }

    public Collection<BlockCapabilityCache<IItemHandler, @Nullable Direction>> getItemCaches() {
        if (this.cacheDirty) {
            this.rebuildAllCaches();
        }
        List<BlockCapabilityCache<IItemHandler, Direction>> rawList = this.capabilityCache.getOrDefault(TransmissionType.ITEM, Collections.emptyList());
        return rawList;
    }

    public Collection<ConnectionConfig> getConnectionsByType(TransmissionType type) {
        return this.connections.stream().filter(c -> c.type() == type).collect(Collectors.toList());
    }

    public Collection<ConnectionConfig> getAllConnections() {
        return Collections.unmodifiableList(this.connections);
    }

    private void rebuildAllCaches() {
        if (this.tile.getLevel() == null || this.tile.getLevel().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.tile.getLevel();
        this.capabilityCache.clear();
        Map<TransmissionType, List<ConnectionConfig>> grouped = this.connections.stream().collect(Collectors.groupingBy(ConnectionConfig::type));
        for (Map.Entry<TransmissionType, List<ConnectionConfig>> entry : grouped.entrySet()) {
            TransmissionType type = entry.getKey();
            ArrayList<Object> caches = new ArrayList<Object>();
            for (ConnectionConfig config : entry.getValue()) {
                Object cache = this.createCache(level, config);
                if (cache == null) continue;
                caches.add(cache);
            }
            if (caches.isEmpty()) continue;
            this.capabilityCache.put(type, caches);
        }
        this.cacheDirty = false;
    }

    private Object createCache(ServerLevel level, ConnectionConfig config) {
        return switch (config.type()) {
            default -> throw new MatchException(null, null);
            case TransmissionType.ENERGY -> BlockEnergyCapabilityCache.create((ServerLevel)level, (BlockPos)config.pos(), (Direction)config.direction());
            case TransmissionType.FLUID -> Capabilities.FLUID.createCache(level, config.pos(), config.direction());
            case TransmissionType.CHEMICAL -> Capabilities.CHEMICAL.createCache(level, config.pos(), config.direction());
            case TransmissionType.ITEM -> Capabilities.ITEM.createCache(level, config.pos(), config.direction());
            case TransmissionType.HEAT -> BlockCapabilityCache.create((BlockCapability)Capabilities.HEAT, (ServerLevel)level, (BlockPos)config.pos(), (Object)config.direction());
        };
    }

    public void validateConnections() {
        if (this.tile.getLevel() == null || this.tile.getLevel().isClientSide()) {
            return;
        }
        boolean removed = this.connections.removeIf(config -> !this.tile.getLevel().isLoaded(config.pos()) || this.tile.getLevel().isEmptyBlock(config.pos()) || !this.validateCapability(config.pos(), config.direction(), config.type()));
        if (removed) {
            this.tile.sendUpdatePacket();
            this.tile.markForSave();
            this.cacheDirty = true;
        }
    }

    public void saveToNBT(CompoundTag tag) {
        ListTag list = new ListTag();
        for (ConnectionConfig config : this.connections) {
            list.add((Object)config.toNBT());
        }
        tag.put("connections", (Tag)list);
    }

    public void loadFromNBT(CompoundTag tag) {
        this.connections.clear();
        if (tag.contains("connections", 9)) {
            ListTag list = tag.getList("connections", 10);
            for (int i = 0; i < list.size(); ++i) {
                try {
                    ConnectionConfig config = ConnectionConfig.fromNBT(list.getCompound(i));
                    this.connections.add(config);
                    continue;
                }
                catch (Exception e) {
                    Mekmm.LOGGER.warn("Failed to load wireless connection: {}", (Object)e.getMessage());
                }
            }
        }
        this.cacheDirty = true;
    }

    public final List<ConnectionConfig> getConnections() {
        return this.connections;
    }

    public int getConnectionCount(TransmissionType type) {
        return (int)this.connections.stream().filter(c -> c.type() == type).count();
    }

    public final int getConnectionCount() {
        return this.connections.size();
    }

    public void remove(ConnectionConfig config) {
        this.connections.remove(config);
        this.cacheDirty = true;
        this.tile.sendUpdatePacket();
        this.tile.markForSave();
    }

    public void clear() {
        this.connections.clear();
        this.capabilityCache.clear();
        this.cacheDirty = true;
    }
}

