/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.render;

import com.jerry.mekmm.client.render.BlockHighlightManager;
import com.jerry.mekmm.client.renderer.NoDepthRenderType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class RenderTickHandler {
    @SubscribeEvent
    public void renderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        Vec3 cameraPos = event.getCamera().getPosition();
        long gameTime = mc.level.getGameTime();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.pushPose();
        for (BlockPos pos : BlockHighlightManager.getInstance().getHighlightedPositions()) {
            BlockHighlightManager.HighlightData data = BlockHighlightManager.getInstance().getHighlightData(pos);
            if (data == null) continue;
            RenderTickHandler.renderHighlight(poseStack, (MultiBufferSource)bufferSource, pos, cameraPos, data, gameTime);
        }
        poseStack.popPose();
        RenderSystem.disableBlend();
    }

    private static void renderHighlight(PoseStack poseStack, MultiBufferSource bufferSource, BlockPos pos, Vec3 cameraPos, BlockHighlightManager.HighlightData data, long gameTime) {
        poseStack.pushPose();
        poseStack.translate((double)pos.getX() - cameraPos.x, (double)pos.getY() - cameraPos.y, (double)pos.getZ() - cameraPos.z);
        VertexConsumer consumer = bufferSource.getBuffer(NoDepthRenderType.LINES_NO_DEPTH);
        float alpha = data.getAlpha(gameTime);
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (float)data.getRed(), (float)data.getGreen(), (float)data.getBlue(), (float)alpha);
        poseStack.popPose();
    }
}

