/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderLineHelper {
    public static void renderLine(PoseStack poseStack, MultiBufferSource buffers, Vector3f start, Vector3f end, float r, float g, float b, float thickness) {
        Vector3f dir = new Vector3f((Vector3fc)end).sub((Vector3fc)start);
        float len = dir.length();
        if ((double)len <= 1.0E-5) {
            return;
        }
        dir.normalize();
        poseStack.pushPose();
        poseStack.translate(start.x(), start.y(), start.z());
        Matrix4f matrix = poseStack.last().pose();
        VertexConsumer vc = buffers.getBuffer(RenderType.lightning());
        Vector3f perpendicular1 = RenderLineHelper.getPerpendicular(dir);
        Vector3f perpendicular2 = new Vector3f((Vector3fc)dir).cross((Vector3fc)perpendicular1).normalize();
        float radius = thickness / 2.0f;
        int light = 0xF000F0;
        int overlay = 0;
        int segments = 8;
        for (int i = 0; i < segments; ++i) {
            double angle1 = Math.PI * 2 * (double)i / (double)segments;
            double angle2 = Math.PI * 2 * (double)(i + 1) / (double)segments;
            Vector3f offset1 = RenderLineHelper.getCirclePoint(perpendicular1, perpendicular2, angle1, radius);
            Vector3f offset2 = RenderLineHelper.getCirclePoint(perpendicular1, perpendicular2, angle2, radius);
            Vector3f v1Start = new Vector3f((Vector3fc)offset1);
            Vector3f v2Start = new Vector3f((Vector3fc)offset2);
            Vector3f v1End = new Vector3f((Vector3fc)offset1).add((Vector3fc)new Vector3f((Vector3fc)dir).mul(len));
            Vector3f v2End = new Vector3f((Vector3fc)offset2).add((Vector3fc)new Vector3f((Vector3fc)dir).mul(len));
            RenderLineHelper.addQuad(vc, matrix, v1Start, v2Start, v2End, v1End, r, g, b, 0.8f, light, overlay);
        }
        poseStack.popPose();
    }

    private static Vector3f getPerpendicular(Vector3f dir) {
        Vector3f perp = new Vector3f();
        if (Math.abs(dir.y()) < 0.99f) {
            perp.set(0.0f, 1.0f, 0.0f);
        } else {
            perp.set(1.0f, 0.0f, 0.0f);
        }
        perp.cross((Vector3fc)dir).normalize();
        return perp;
    }

    private static Vector3f getCirclePoint(Vector3f perp1, Vector3f perp2, double angle, float radius) {
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        return new Vector3f((Vector3fc)perp1).mul(cos * radius).add((Vector3fc)new Vector3f((Vector3fc)perp2).mul(sin * radius));
    }

    private static void addQuad(VertexConsumer vc, Matrix4f matrix, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, float r, float g, float b, float a, int light, int overlay) {
        Vector3f edge1 = new Vector3f((Vector3fc)p2).sub((Vector3fc)p1);
        Vector3f edge2 = new Vector3f((Vector3fc)p4).sub((Vector3fc)p1);
        Vector3f normal = new Vector3f((Vector3fc)edge1).cross((Vector3fc)edge2).normalize();
        vc.addVertex(matrix, p1.x(), p1.y(), p1.z()).setColor(r, g, b, a).setUv(0.0f, 0.0f).setLight(light).setOverlay(overlay).setNormal(normal.x(), normal.y(), normal.z());
        vc.addVertex(matrix, p2.x(), p2.y(), p2.z()).setColor(r, g, b, a).setUv(1.0f, 0.0f).setLight(light).setOverlay(overlay).setNormal(normal.x(), normal.y(), normal.z());
        vc.addVertex(matrix, p3.x(), p3.y(), p3.z()).setColor(r, g, b, a).setUv(1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(normal.x(), normal.y(), normal.z());
        vc.addVertex(matrix, p4.x(), p4.y(), p4.z()).setColor(r, g, b, a).setUv(0.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(normal.x(), normal.y(), normal.z());
    }
}

