/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.render;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;

public class BlockHighlightManager {
    private static final BlockHighlightManager INSTANCE = new BlockHighlightManager();
    private final Map<BlockPos, HighlightData> highlightedBlocks = new ConcurrentHashMap<BlockPos, HighlightData>();

    private BlockHighlightManager() {
    }

    public static BlockHighlightManager getInstance() {
        return INSTANCE;
    }

    public void addHighlight(BlockPos pos, int duration) {
        this.highlightedBlocks.put(pos, new HighlightData(duration));
    }

    public void addHighlight(BlockPos pos) {
        this.addHighlight(pos, 200);
    }

    public void addHighlight(BlockPos pos, int duration, float r, float g, float b) {
        this.highlightedBlocks.put(pos, new HighlightData(duration, r, g, b));
    }

    public void removeHighlight(BlockPos pos) {
        this.highlightedBlocks.remove(pos);
    }

    public boolean isHighlighted(BlockPos pos) {
        return this.highlightedBlocks.containsKey(pos);
    }

    public HighlightData getHighlightData(BlockPos pos) {
        return this.highlightedBlocks.get(pos);
    }

    public void tick() {
        Iterator<Map.Entry<BlockPos, HighlightData>> iterator = this.highlightedBlocks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, HighlightData> entry = iterator.next();
            HighlightData data = entry.getValue();
            --data.remainingTicks;
            if (data.remainingTicks > 0) continue;
            iterator.remove();
        }
    }

    public void clear() {
        this.highlightedBlocks.clear();
    }

    public Iterable<BlockPos> getHighlightedPositions() {
        return this.highlightedBlocks.keySet();
    }

    public static class HighlightData {
        int remainingTicks;
        private final float red;
        private final float green;
        private final float blue;
        protected final float baseAlpha;

        public HighlightData(int ticks) {
            this(ticks, 1.0f, 0.0f, 0.0f);
        }

        public HighlightData(int ticks, float r, float g, float b) {
            this(ticks, r, g, b, 1.0f);
        }

        public HighlightData(int ticks, float r, float g, float b, float alpha) {
            this.remainingTicks = ticks;
            this.baseAlpha = alpha;
            this.red = r;
            this.green = g;
            this.blue = b;
        }

        public int getRemainingTicks() {
            return this.remainingTicks;
        }

        public float getRed() {
            return this.red;
        }

        public float getGreen() {
            return this.green;
        }

        public float getBlue() {
            return this.blue;
        }

        public float getAlpha(long gameTime) {
            float flash = (float)(Math.sin((double)gameTime * 0.5) * 0.3 + 0.7);
            return this.baseAlpha * flash;
        }
    }
}

