/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.recipe_viewer.jei.machine;

import com.jerry.mekmm.api.recipes.RecyclerRecipe;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiUpArrow;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.jei.HolderRecipeCategory;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.util.text.TextUtils;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.crafting.RecipeHolder;

@NothingNullByDefault
public class RecyclerRecipeCategory
extends HolderRecipeCategory<RecyclerRecipe> {
    private final GuiSlot input;
    private final GuiSlot output;

    public RecyclerRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<RecyclerRecipe> recipeType) {
        super(helper, recipeType);
        this.addElement((GuiElement)new GuiUpArrow((IGuiWrapper)this, 68, 38));
        this.input = this.addSlot(SlotType.INPUT, 64, 17);
        this.output = this.addSlot(SlotType.OUTPUT, 116, 35);
        this.addSlot(SlotType.POWER, 64, 53).with(SlotOverlay.POWER);
        this.addElement((GuiElement)new GuiVerticalPowerBar((IGuiWrapper)this, RecipeViewerUtils.FULL_BAR, 164, 16));
        this.addSimpleProgress(ProgressType.BAR, 86, 38);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<RecyclerRecipe> recipeHolder, IFocusGroup focuses) {
        super.createRecipeExtras(builder, recipeHolder, focuses);
        double secondaryChance = ((RecyclerRecipe)recipeHolder.value()).getOutputChance();
        if (secondaryChance > 0.0) {
            Component component = TextUtils.getPercent((double)secondaryChance);
            int n = this.output.getWidth();
            Objects.requireNonNull(this.font());
            ((ITextWidget)builder.addText((FormattedText)component, n, 9).setPosition(this.getGuiLeft() + this.output.getRelativeX() + 1, this.getGuiTop() + this.output.getRelativeBottom() + 1)).setTextAlignment(HorizontalAlignment.RIGHT).setColor(this.titleTextColor());
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<RecyclerRecipe> recipeHolder, IFocusGroup focuses) {
        RecyclerRecipe recipe = (RecyclerRecipe)recipeHolder.value();
        this.initItem(builder, RecipeIngredientRole.INPUT, this.input, recipe.getInput().getRepresentations());
        this.initItem(builder, RecipeIngredientRole.OUTPUT, this.output, recipe.getChanceOutputDefinition());
    }
}

