/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.gui;

import com.jerry.mekmm.client.gui.GuiConnectListHolder;
import com.jerry.mekmm.client.gui.window.connect.GuiViewConnection;
import com.jerry.mekmm.common.MoreMachineLang;
import com.jerry.mekmm.common.attachments.component.ConnectionConfig;
import com.jerry.mekmm.common.config.MoreMachineConfig;
import com.jerry.mekmm.common.network.to_server.PacketGuiSetDoubleValue;
import com.jerry.mekmm.common.network.to_server.PacketGuiSetIntValue;
import com.jerry.mekmm.common.network.to_server.PacketGuiSetLongValue;
import com.jerry.mekmm.common.tile.machine.TileEntityWirelessTransmissionStation;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.button.PacketTileButtonPress;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.InputValidator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiWirelessTransmissionStationConfig
extends GuiConnectListHolder<TileEntityWirelessTransmissionStation, MekanismTileContainer<TileEntityWirelessTransmissionStation>> {
    private GuiTextField energyRateField;
    private GuiTextField fluidsRateField;
    private GuiTextField chemicalsRateField;
    private GuiTextField itemsRateField;
    private GuiTextField heatRateField;

    public GuiWirelessTransmissionStationConfig(MekanismTileContainer<TileEntityWirelessTransmissionStation> container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        ((MekanismImageButton)this.addRenderableWidget((GuiElement)new MekanismImageButton((IGuiWrapper)this, 5, 5, 11, 14, this.getButtonLocation("back"), (element, mouseX, mouseY) -> PacketUtils.sendToServer((CustomPacketPayload)new PacketTileButtonPress(PacketTileButtonPress.ClickedTileButton.BACK_BUTTON, (BlockEntity)((GuiWirelessTransmissionStationConfig)element.gui()).tile))))).setTooltip(TooltipUtils.BACK);
        this.energyRateField = (GuiTextField)this.addRenderableWidget((GuiElement)new GuiTextField((IGuiWrapper)this, 13, 34, 60, 11));
        this.energyRateField.setMaxLength(Long.toString(MoreMachineConfig.general.energyRate.get()).length());
        this.energyRateField.setInputValidator(InputValidator.DIGIT);
        this.energyRateField.configureDigitalBorderInput(() -> this.setLongText(this.energyRateField, PacketGuiSetLongValue.GuiLongValue.SET_ENERGY_RATE));
        this.fluidsRateField = (GuiTextField)this.addRenderableWidget((GuiElement)new GuiTextField((IGuiWrapper)this, 13, 61, 60, 11));
        this.fluidsRateField.setMaxLength(Integer.toString(MoreMachineConfig.general.fluidsRate.get()).length());
        this.fluidsRateField.setInputValidator(InputValidator.DIGIT);
        this.fluidsRateField.configureDigitalBorderInput(() -> this.setText(this.fluidsRateField, PacketGuiSetIntValue.GuiIntValue.SET_FLUIDS_RATE));
        this.chemicalsRateField = (GuiTextField)this.addRenderableWidget((GuiElement)new GuiTextField((IGuiWrapper)this, 13, 88, 60, 11));
        this.chemicalsRateField.setMaxLength(Long.toString(MoreMachineConfig.general.chemicalsRate.get()).length());
        this.chemicalsRateField.setInputValidator(InputValidator.DIGIT);
        this.chemicalsRateField.configureDigitalBorderInput(() -> this.setLongText(this.chemicalsRateField, PacketGuiSetLongValue.GuiLongValue.SET_CHEMICALS_RATE));
        this.itemsRateField = (GuiTextField)this.addRenderableWidget((GuiElement)new GuiTextField((IGuiWrapper)this, 13, 115, 60, 11));
        this.itemsRateField.setMaxLength(Integer.toString(MoreMachineConfig.general.itemsRate.get()).length());
        this.itemsRateField.setInputValidator(InputValidator.DIGIT);
        this.itemsRateField.configureDigitalBorderInput(() -> this.setText(this.itemsRateField, PacketGuiSetIntValue.GuiIntValue.SET_ITEMS_RATE));
        this.heatRateField = (GuiTextField)this.addRenderableWidget((GuiElement)new GuiTextField((IGuiWrapper)this, 13, 142, 60, 11));
        this.heatRateField.setMaxLength(Double.toString(MoreMachineConfig.general.heatRate.get() * 10000.0).length());
        this.heatRateField.setInputValidator(c -> c >= '0' && c <= '9' || c == '.');
        this.heatRateField.configureDigitalBorderInput(() -> this.setDoubleText(this.heatRateField, PacketGuiSetDoubleValue.GuiDoubleValue.SET_HEAT_RATE));
    }

    protected void addGenericTabs() {
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
        this.renderTitleTextWithOffset(guiGraphics, 14);
        this.drawScreenText(guiGraphics, (Component)MoreMachineLang.WTS_ENERGY_RATE.translate(new Object[]{EnergyDisplay.of((long)((TileEntityWirelessTransmissionStation)this.tile).getEnergyRate())}), 7);
        this.drawScreenText(guiGraphics, (Component)MoreMachineLang.WTS_FLUIDS_RATE.translate(new Object[]{((TileEntityWirelessTransmissionStation)this.tile).getFluidsRate()}), 34);
        this.drawScreenText(guiGraphics, (Component)MoreMachineLang.WTS_CHEMICALS_RATE.translate(new Object[]{((TileEntityWirelessTransmissionStation)this.tile).getChemicalsRate()}), 61);
        this.drawScreenText(guiGraphics, (Component)MoreMachineLang.WTS_ITEMS_RATE.translate(new Object[]{((TileEntityWirelessTransmissionStation)this.tile).getItemsRate()}), 88);
        this.drawScreenText(guiGraphics, (Component)MoreMachineLang.WTS_HEAT_RATE.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)((TileEntityWirelessTransmissionStation)this.tile).getHeatRate(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false)}), 115);
    }

    @Override
    protected void onClick(ConnectionConfig config, int index) {
        this.addWindow(GuiViewConnection.create((IGuiWrapper)this, (TileEntityWirelessTransmissionStation)this.tile, this.level, config));
    }

    private void setLongText(GuiTextField field, PacketGuiSetLongValue.GuiLongValue interaction) {
        if (!field.getText().isEmpty()) {
            try {
                PacketUtils.sendToServer((CustomPacketPayload)new PacketGuiSetLongValue(interaction, ((TileEntityWirelessTransmissionStation)this.tile).getBlockPos(), Long.parseLong(field.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            field.setText("");
        }
    }

    private void setText(GuiTextField field, PacketGuiSetIntValue.GuiIntValue interaction) {
        if (!field.getText().isEmpty()) {
            try {
                PacketUtils.sendToServer((CustomPacketPayload)new PacketGuiSetIntValue(interaction, ((TileEntityWirelessTransmissionStation)this.tile).getBlockPos(), Integer.parseInt(field.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            field.setText("");
        }
    }

    private void setDoubleText(GuiTextField field, PacketGuiSetDoubleValue.GuiDoubleValue interaction) {
        if (!field.getText().isEmpty()) {
            try {
                PacketUtils.sendToServer((CustomPacketPayload)new PacketGuiSetDoubleValue(interaction, ((TileEntityWirelessTransmissionStation)this.tile).getBlockPos(), Double.parseDouble(field.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            field.setText("");
        }
    }
}

