/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.cache;

import com.jerry.mekmm.api.recipes.PlantingRecipe;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackConstantChemicalToObjectCachedRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class PlantingCachedRecipe
extends CachedRecipe<PlantingRecipe> {
    protected final Predicate<SawmillRecipe.ChanceOutput> outputEmptyCheck;
    protected final IOutputHandler<// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SawmillRecipe.ChanceOutput> outputHandler;
    protected final IInputHandler<@NotNull ItemStack> itemInputHandler;
    protected final ILongInputHandler<ChemicalStack> chemicalInputHandler;
    protected final ItemStackConstantChemicalToObjectCachedRecipe.ChemicalUsageMultiplier chemicalUsage;
    protected final LongConsumer chemicalUsedSoFarChanged;
    protected long chemicalUsageMultiplier;
    protected long chemicalUsedSoFar;
    protected ItemStack recipeItem = ItemStack.EMPTY;
    @Nullable
    protected ChemicalStack recipeChemical;
    @Nullable
    protected SawmillRecipe.ChanceOutput output;

    public PlantingCachedRecipe(PlantingRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> itemInputHandler, ILongInputHandler<ChemicalStack> chemicalInputHandler, ItemStackConstantChemicalToObjectCachedRecipe.ChemicalUsageMultiplier chemicalUsage, LongConsumer chemicalUsedSoFarChanged, IOutputHandler<// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SawmillRecipe.ChanceOutput> outputHandler, Predicate<SawmillRecipe.ChanceOutput> outputEmptyCheck) {
        super((MekanismRecipe)recipe, recheckAllErrors);
        this.itemInputHandler = Objects.requireNonNull(itemInputHandler, "Item input handler cannot be null.");
        this.chemicalInputHandler = Objects.requireNonNull(chemicalInputHandler, "Chemical input handler cannot be null.");
        this.chemicalUsage = Objects.requireNonNull(chemicalUsage, "Chemical usage cannot be null.");
        this.chemicalUsedSoFarChanged = Objects.requireNonNull(chemicalUsedSoFarChanged, "Chemical used so far changed handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
        this.outputEmptyCheck = Objects.requireNonNull(outputEmptyCheck, "Output empty check cannot be null.");
    }

    public void loadSavedUsageSoFar(long chemicalUsedSoFar) {
        if (chemicalUsedSoFar > 0L) {
            this.chemicalUsedSoFar = chemicalUsedSoFar;
        }
    }

    protected void setupVariableValues() {
        this.chemicalUsageMultiplier = Math.max(this.chemicalUsage.getToUse(this.chemicalUsedSoFar, this.getOperatingTicks()), 0L);
    }

    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        if (tracker.shouldContinueChecking()) {
            this.recipeItem = (ItemStack)this.itemInputHandler.getRecipeInput((InputIngredient)((PlantingRecipe)this.recipe).getItemInput());
            if (this.recipeItem.isEmpty()) {
                tracker.mismatchedRecipe();
            } else {
                this.recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient)((PlantingRecipe)this.recipe).getChemicalInput());
                if (this.recipeChemical.isEmpty()) {
                    tracker.updateOperations(0);
                    if (!tracker.shouldContinueChecking()) {
                        return;
                    }
                }
                this.itemInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeItem);
                if (!this.recipeChemical.isEmpty() && tracker.shouldContinueChecking()) {
                    this.chemicalInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeChemical, this.chemicalUsageMultiplier);
                    if (tracker.shouldContinueChecking()) {
                        this.output = ((PlantingRecipe)this.recipe).getOutput(this.recipeItem, this.recipeChemical);
                        this.outputHandler.calculateOperationsCanSupport(tracker, (Object)this.output);
                    }
                }
            }
        }
    }

    public boolean isInputValid() {
        ChemicalStack chemicalStack;
        ItemStack itemInput = (ItemStack)this.itemInputHandler.getInput();
        if (!itemInput.isEmpty() && !(chemicalStack = (ChemicalStack)this.chemicalInputHandler.getInput()).isEmpty() && ((PlantingRecipe)this.recipe).test(itemInput, chemicalStack)) {
            ChemicalStack recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient)((PlantingRecipe)this.recipe).getChemicalInput());
            return !recipeChemical.isEmpty() && chemicalStack.getAmount() >= recipeChemical.getAmount();
        }
        return false;
    }

    protected void useResources(int operations) {
        super.useResources(operations);
        if (this.chemicalUsageMultiplier <= 0L) {
            return;
        }
        if (this.recipeChemical == null || this.recipeChemical.isEmpty()) {
            return;
        }
        long toUse = (long)operations * this.chemicalUsageMultiplier;
        this.chemicalInputHandler.use((Object)this.recipeChemical, toUse);
        this.chemicalUsedSoFar += toUse;
        this.chemicalUsedSoFarChanged.accept(this.chemicalUsedSoFar);
    }

    protected void resetCache() {
        super.resetCache();
        this.chemicalUsedSoFar = 0L;
        this.chemicalUsedSoFarChanged.accept(this.chemicalUsedSoFar);
    }

    protected void finishProcessing(int operations) {
        if (!(this.recipeChemical == null || this.output == null || this.recipeItem.isEmpty() || this.recipeChemical.isEmpty() || this.outputEmptyCheck.test(this.output))) {
            if (this.chemicalUsageMultiplier > 0L) {
                this.chemicalInputHandler.use((Object)this.recipeChemical, (long)operations * this.chemicalUsageMultiplier);
            }
            this.outputHandler.handleOutput((Object)this.output, operations);
        }
    }

    public static PlantingCachedRecipe planting(PlantingRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> itemInputHandler, ILongInputHandler<@NotNull ChemicalStack> chemicalInputHandler, ItemStackConstantChemicalToObjectCachedRecipe.ChemicalUsageMultiplier chemicalUsage, LongConsumer chemicalUsedSoFarChanged, IOutputHandler<SawmillRecipe.ChanceOutput> outputHandler) {
        return new PlantingCachedRecipe(recipe, recheckAllErrors, itemInputHandler, chemicalInputHandler, chemicalUsage, chemicalUsedSoFarChanged, outputHandler, ConstantPredicates.alwaysFalse());
    }
}

