/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.cache;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.CachedRecipeHelper;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class MoreMachineTwoInputCachedRecipe<INPUT_A, INPUT_B, OUTPUT, RECIPE extends MekanismRecipe<?>>
extends CachedRecipe<RECIPE> {
    protected final IInputHandler<INPUT_A> inputHandler;
    protected final IInputHandler<INPUT_B> secondaryInputHandler;
    protected final IOutputHandler<OUTPUT> outputHandler;
    protected final Predicate<INPUT_A> inputEmptyCheck;
    protected final Predicate<INPUT_B> secondaryInputEmptyCheck;
    protected final Supplier<? extends InputIngredient<INPUT_A>> inputSupplier;
    protected final Supplier<? extends InputIngredient<INPUT_B>> secondaryInputSupplier;
    protected final BiFunction<INPUT_A, INPUT_B, OUTPUT> outputGetter;
    protected final Predicate<OUTPUT> outputEmptyCheck;
    protected final BiConsumer<INPUT_A, INPUT_B> inputsSetter;
    protected final Consumer<OUTPUT> outputSetter;
    @Nullable
    protected INPUT_A input;
    @Nullable
    protected INPUT_B secondaryInput;
    @Nullable
    protected OUTPUT output;

    protected MoreMachineTwoInputCachedRecipe(RECIPE recipe, BooleanSupplier recheckAllErrors, IInputHandler<INPUT_A> inputHandler, IInputHandler<INPUT_B> secondaryInputHandler, IOutputHandler<OUTPUT> outputHandler, Supplier<InputIngredient<INPUT_A>> inputSupplier, Supplier<InputIngredient<INPUT_B>> secondaryInputSupplier, BiFunction<INPUT_A, INPUT_B, OUTPUT> outputGetter, Predicate<INPUT_A> inputEmptyCheck, Predicate<INPUT_B> secondaryInputEmptyCheck, Predicate<OUTPUT> outputEmptyCheck) {
        super(recipe, recheckAllErrors);
        this.inputHandler = Objects.requireNonNull(inputHandler, "Input handler cannot be null.");
        this.secondaryInputHandler = Objects.requireNonNull(secondaryInputHandler, "Secondary input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
        this.inputSupplier = Objects.requireNonNull(inputSupplier, "Input ingredient supplier cannot be null.");
        this.secondaryInputSupplier = Objects.requireNonNull(secondaryInputSupplier, "Secondary input ingredient supplier cannot be null.");
        this.outputGetter = Objects.requireNonNull(outputGetter, "Output getter cannot be null.");
        this.inputEmptyCheck = Objects.requireNonNull(inputEmptyCheck, "Input empty check cannot be null.");
        this.secondaryInputEmptyCheck = Objects.requireNonNull(secondaryInputEmptyCheck, "Secondary input empty check cannot be null.");
        this.outputEmptyCheck = Objects.requireNonNull(outputEmptyCheck, "Output empty check cannot be null.");
        this.inputsSetter = (input, secondary) -> {
            this.input = input;
            this.secondaryInput = secondary;
        };
        this.outputSetter = output -> {
            this.output = output;
        };
    }

    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        CachedRecipeHelper.twoInputCalculateOperationsThisTick((CachedRecipe.OperationTracker)tracker, this.inputHandler, this.inputSupplier, this.secondaryInputHandler, this.secondaryInputSupplier, this.inputsSetter, this.outputHandler, this.outputGetter, this.outputSetter, this.inputEmptyCheck, this.secondaryInputEmptyCheck);
    }

    public boolean isInputValid() {
        Object input = this.inputHandler.getInput();
        if (this.inputEmptyCheck.test(input)) {
            return false;
        }
        Object secondaryInput = this.secondaryInputHandler.getInput();
        return !this.secondaryInputEmptyCheck.test(secondaryInput) && ((BiPredicate)this.recipe).test(input, secondaryInput);
    }

    protected void finishProcessing(int operations) {
        if (!(this.input == null || this.secondaryInput == null || this.output == null || this.inputEmptyCheck.test(this.input) || this.secondaryInputEmptyCheck.test(this.secondaryInput) || this.outputEmptyCheck.test(this.output))) {
            this.inputHandler.use(this.input, operations);
            this.secondaryInputHandler.use(this.secondaryInput, operations);
            this.outputHandler.handleOutput(this.output, operations);
        }
    }
}

