/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.basic.IBasicItemStackOutput;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public abstract class MMBasicItemStackChemicalToItemStackRecipe
extends ItemStackChemicalToItemStackRecipe
implements IBasicItemStackOutput {
    protected final ItemStackIngredient itemInput;
    protected final ChemicalStackIngredient chemicalInput;
    protected final ItemStack output;

    public MMBasicItemStackChemicalToItemStackRecipe(ItemStackIngredient itemInput, ChemicalStackIngredient chemicalInput, ItemStack output) {
        this.itemInput = Objects.requireNonNull(itemInput, "Item input cannot be null.");
        this.chemicalInput = Objects.requireNonNull(chemicalInput, "Chemical input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
    }

    public ItemStackIngredient getItemInput() {
        return this.itemInput;
    }

    public ChemicalStackIngredient getChemicalInput() {
        return this.chemicalInput;
    }

    @Contract(value="_, _ -> new", pure=true)
    public ItemStack getOutput(ItemStack inputItem, ChemicalStack inputChemical) {
        return this.output.copy();
    }

    public final boolean perTickUsage() {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean test(ItemStack itemStack, ChemicalStack chemicalStack) {
        return this.itemInput.test(itemStack) && this.chemicalInput.test(chemicalStack);
    }

    public List<@NotNull ItemStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    public ItemStack getOutputRaw() {
        return this.output;
    }
}

