/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.meklm.common.tile.prefab;

import com.jerry.meklm.api.tier.ILargeChemicalTankTier;
import com.jerry.meklm.common.capabilities.holder.chemical.CanAdjustChemicalTankHelper;
import com.jerry.meklm.common.capabilities.holder.chemical.LargeChemicalTankChemicalTank;
import com.jerry.meklm.common.tile.INotNeedConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import lombok.Generated;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.interfaces.IHasGasMode;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.upgrade.ChemicalTankUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLargeChemicalTank<TIER extends ILargeChemicalTankTier>
extends TileEntityConfigurableMachine
implements IHasGasMode,
IBoundingBlock,
INotNeedConfig {
    private static final RelativeSide[] CHEMICAL_SIDES = new RelativeSide[]{RelativeSide.TOP};
    @SyntheticComputerMethod(getter="getDumpingMode", getterDescription="Get the current Dumping configuration")
    public TileEntityChemicalTank.GasMode dumping = TileEntityChemicalTank.GasMode.IDLE;
    protected int numPowering;
    @Nullable
    private @Nullable List<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> outputCaches;
    private IChemicalTank chemicalTank;
    protected TIER tier;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getDrainItem"}, docPlaceholder="drain slot")
    ChemicalInventorySlot drainSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFillItem"}, docPlaceholder="fill slot")
    ChemicalInventorySlot fillSlot;

    public TileEntityLargeChemicalTank(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.configComponent.setupIOConfig(TransmissionType.ITEM, (Object)this.drainSlot, (Object)this.fillSlot, RelativeSide.BACK, true).setCanEject(false);
        this.configComponent.setupIOConfig(TransmissionType.CHEMICAL, (Object)this.getChemicalTank(), RelativeSide.TOP);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this, () -> this.tier.getOutput());
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.CHEMICAL}).setCanEject(type -> this.canFunction() && this.dumping != TileEntityChemicalTank.GasMode.DUMPING);
    }

    @Nullable
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        CanAdjustChemicalTankHelper builder = CanAdjustChemicalTankHelper.forSide(this.facingSupplier, side -> side == RelativeSide.BACK, side -> side == RelativeSide.TOP);
        this.chemicalTank = LargeChemicalTankChemicalTank.create(this.tier, listener);
        builder.addTank(this.chemicalTank, RelativeSide.TOP, RelativeSide.BACK);
        return builder.build();
    }

    protected RelativeSide[] getChemicalSides() {
        return CHEMICAL_SIDES;
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide((Supplier)this.facingSupplier, side -> side == RelativeSide.TOP, side -> side == RelativeSide.BACK);
        this.drainSlot = ChemicalInventorySlot.drain((IChemicalTank)this.chemicalTank, (IContentsListener)listener, (int)16, (int)16);
        builder.addSlot((IInventorySlot)this.drainSlot, new RelativeSide[]{RelativeSide.TOP, RelativeSide.BACK});
        this.fillSlot = ChemicalInventorySlot.fill((IChemicalTank)this.chemicalTank, (IContentsListener)listener, (int)16, (int)48);
        builder.addSlot((IInventorySlot)this.fillSlot, new RelativeSide[]{RelativeSide.TOP, RelativeSide.BACK});
        this.drainSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.drainSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.fillSlot.setSlotType(ContainerSlotType.INPUT);
        this.fillSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.drainSlot.drainTank();
        this.fillSlot.fillTank();
        if (this.dumping != TileEntityChemicalTank.GasMode.IDLE) {
            if (this.dumping == TileEntityChemicalTank.GasMode.DUMPING) {
                this.chemicalTank.shrinkStack(this.tier.getStorage() / 400L, Action.EXECUTE);
            } else {
                long stored;
                long target = MathUtils.clampToLong((double)((double)this.chemicalTank.getCapacity() * MekanismConfig.general.dumpExcessKeepRatio.get()));
                if (target < (stored = this.chemicalTank.getStored())) {
                    this.chemicalTank.shrinkStack(Math.min(stored - target, this.tier.getOutput()), Action.EXECUTE);
                }
            }
        }
        if (this.canFunction()) {
            if (this.outputCaches == null) {
                Direction direction = this.getDirection();
                RelativeSide[] chemicalSides = this.getChemicalSides();
                this.outputCaches = new ArrayList<BlockCapabilityCache<IChemicalHandler, Direction>>(chemicalSides.length);
                for (RelativeSide chemicalSide : chemicalSides) {
                    Direction side = chemicalSide.getDirection(direction);
                    this.outputCaches.add((BlockCapabilityCache<IChemicalHandler, Direction>)Capabilities.CHEMICAL.createCache((ServerLevel)this.level, this.offSetOutput(this.worldPosition, side), side.getOpposite()));
                }
            }
            ChemicalUtil.emit(this.outputCaches, (IChemicalTank)this.chemicalTank, (long)this.tier.getOutput());
        }
        return sendUpdatePacket;
    }

    protected BlockPos offSetOutput(BlockPos from, Direction side) {
        return from.relative(side);
    }

    protected void invalidateDirectionCaches(Direction newDirection) {
        super.invalidateDirectionCaches(newDirection);
        this.outputCaches = null;
    }

    public void nextMode(int tank) {
        if (tank == 0) {
            this.dumping = (TileEntityChemicalTank.GasMode)this.dumping.getNext();
            this.markForSave();
        }
    }

    public int getRedstoneLevel() {
        IChemicalTank currentTank = this.getCurrentTank();
        return MekanismUtils.redstoneLevelFromContents((long)currentTank.getStored(), (long)currentTank.getCapacity());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.CHEMICAL;
    }

    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getStored", "getCapacity", "getNeeded", "getFilledPercentage"}, docPlaceholder="tank")
    IChemicalTank getCurrentTank() {
        return this.chemicalTank;
    }

    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof ChemicalTankUpgradeData) {
            ChemicalTankUpgradeData data = (ChemicalTankUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.drainSlot.setStack(data.drainSlot.getStack());
            this.fillSlot.setStack(data.fillSlot.getStack());
            this.dumping = data.dumping;
            this.getChemicalTank().setStack(data.storedChemical);
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components, provider);
            }
        } else {
            super.parseUpgradeData(provider, upgradeData);
        }
    }

    @NotNull
    public ChemicalTankUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new ChemicalTankUpgradeData(provider, this.redstone, this.getControlType(), this.drainSlot, this.fillSlot, this.dumping, this.getChemicalTank().getStack(), this.getComponents());
    }

    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag dataMap) {
        super.writeSustainedData(provider, dataMap);
        NBTUtils.writeEnum((CompoundTag)dataMap, (String)"dumping", (Enum)this.dumping);
    }

    public void readSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag data) {
        super.readSustainedData(provider, data);
        NBTUtils.setEnumIfPresent((CompoundTag)data, (String)"dumping", (IntFunction)TileEntityChemicalTank.GasMode.BY_ID, mode -> {
            this.dumping = mode;
        });
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((Supplier)MekanismDataComponents.DUMP_MODE, (Object)this.dumping);
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.dumping = (TileEntityChemicalTank.GasMode)input.getOrDefault((Supplier)MekanismDataComponents.DUMP_MODE, (Object)this.dumping);
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create((IntFunction)TileEntityChemicalTank.GasMode.BY_ID, (Enum)TileEntityChemicalTank.GasMode.IDLE, () -> this.dumping, value -> {
            this.dumping = value;
        }));
    }

    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    public void onBoundingBlockPowerChange(BlockPos boundingPos, int oldLevel, int newLevel) {
        if (oldLevel > 0) {
            if (newLevel == 0) {
                --this.numPowering;
            }
        } else if (newLevel > 0) {
            ++this.numPowering;
        }
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Set the Dumping mode of the tank")
    void setDumpingMode(TileEntityChemicalTank.GasMode mode) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.dumping != mode) {
            this.dumping = mode;
            this.markForSave();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Advance the Dumping mode to the next configuration in the list")
    void incrementDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.nextMode(0);
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Descend the Dumping mode to the previous configuration in the list")
    void decrementDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.dumping = (TileEntityChemicalTank.GasMode)this.dumping.getPrevious();
        this.markForSave();
    }

    @Generated
    public IChemicalTank getChemicalTank() {
        return this.chemicalTank;
    }

    @Generated
    public TIER getTier() {
        return this.tier;
    }
}

