/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.meklm.common.tile.machine;

import com.jerry.meklm.common.capabilities.holder.chemical.CanAdjustChemicalTankHelper;
import com.jerry.meklm.common.capabilities.holder.fluid.CanAdjustFluidTankHelper;
import com.jerry.meklm.common.registries.LargeMachineBlocks;
import com.jerry.meklm.common.tile.INotNeedConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import lombok.Generated;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.RotaryCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.api.recipes.vanilla_input.RotaryRecipeInput;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.RotaryInputRecipeCache;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLargeRotaryCondensentrator
extends TileEntityRecipeMachine<RotaryRecipe>
implements IHasMode,
IBoundingBlock,
INotNeedConfig {
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_FLUID_INPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_GAS_INPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_GAS_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_FLUID_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final int CAPACITY = 10000000;
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, NOT_ENOUGH_FLUID_INPUT_ERROR, NOT_ENOUGH_GAS_INPUT_ERROR, NOT_ENOUGH_SPACE_GAS_OUTPUT_ERROR, NOT_ENOUGH_SPACE_FLUID_OUTPUT_ERROR, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private final IOutputHandler<@NotNull ChemicalStack> chemicalOutputHandler;
    private final IOutputHandler<@NotNull FluidStack> fluidOutputHandler;
    private final IInputHandler<@NotNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NotNull ChemicalStack> chemicalInputHandler;
    @Nullable
    private @Nullable List<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> leftOutputCaches;
    @Nullable
    private @Nullable List<BlockCapabilityCache<IFluidHandler, @Nullable Direction>> rightOutputCaches;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getChemical", "getChemicalCapacity", "getChemicalNeeded", "getChemicalFilledPercentage"}, docPlaceholder="gas tank")
    public IChemicalTank chemicalTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getFluid", "getFluidCapacity", "getFluidNeeded", "getFluidFilledPercentage"}, docPlaceholder="fluid tank")
    public BasicFluidTank fluidTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getChemicalItemInput"}, docPlaceholder="gas item input slot")
    ChemicalInventorySlot gasInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getChemicalItemOutput"}, docPlaceholder="gas item output slot")
    ChemicalInventorySlot gasOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFluidItemInput"}, docPlaceholder="fluid item input slot")
    FluidInventorySlot fluidInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFluidItemOutput"}, docPlaceholder="fluid item ouput slot")
    OutputInventorySlot fluidOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;
    private boolean mode;
    private long clientEnergyUsed = 0L;
    private int baselineMaxOperations = 1;
    private int baseOperations = 8;
    private int numPowering;
    private MachineEnergyContainer<TileEntityLargeRotaryCondensentrator> energyContainer;

    public TileEntityLargeRotaryCondensentrator(BlockPos pos, BlockState state) {
        super(LargeMachineBlocks.LARGE_ROTARY_CONDENSENTRATOR, pos, state, TRACKED_ERROR_TYPES);
        this.configComponent.setupItemIOConfig(List.of(this.gasInputSlot, this.fluidInputSlot), List.of(this.gasOutputSlot, this.fluidOutputSlot), (IInventorySlot)this.energySlot, true);
        this.configComponent.setupIOConfig(TransmissionType.CHEMICAL, (Object)this.chemicalTank, RelativeSide.LEFT, true);
        this.configComponent.setupIOConfig(TransmissionType.FLUID, (Object)this.fluidTank, RelativeSide.RIGHT, true);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.CHEMICAL, TransmissionType.FLUID}).setCanEject(transmissionType -> {
            if (transmissionType == TransmissionType.CHEMICAL) {
                return this.mode;
            }
            if (transmissionType == TransmissionType.FLUID) {
                return !this.mode;
            }
            return true;
        });
        this.chemicalInputHandler = InputHelper.getInputHandler((IChemicalTank)this.chemicalTank, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_GAS_INPUT_ERROR);
        this.fluidInputHandler = InputHelper.getInputHandler((IExtendedFluidTank)this.fluidTank, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_FLUID_INPUT_ERROR);
        this.chemicalOutputHandler = OutputHelper.getOutputHandler((IChemicalTank)this.chemicalTank, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_SPACE_GAS_OUTPUT_ERROR);
        this.fluidOutputHandler = OutputHelper.getOutputHandler((IExtendedFluidTank)this.fluidTank, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_SPACE_FLUID_OUTPUT_ERROR);
    }

    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        CanAdjustChemicalTankHelper builder = CanAdjustChemicalTankHelper.forSide(this.facingSupplier, side -> side == RelativeSide.BACK, side -> side == RelativeSide.LEFT);
        this.chemicalTank = BasicChemicalTank.createModern((long)10000000L, (gas, automationType) -> automationType == AutomationType.MANUAL || this.mode, (gas, automationType) -> automationType == AutomationType.INTERNAL || !this.mode, this::isValidChemical, (ChemicalAttributeValidator)ChemicalAttributeValidator.ALWAYS_ALLOW, (IContentsListener)recipeCacheListener);
        builder.addTank(this.chemicalTank, RelativeSide.BACK, RelativeSide.LEFT);
        return builder.build();
    }

    private boolean isValidChemical(@NotNull ChemicalStack chemical) {
        return ((RotaryInputRecipeCache)this.getRecipeType().getInputCache()).containsInput(this.level, chemical);
    }

    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        CanAdjustFluidTankHelper builder = CanAdjustFluidTankHelper.forSide(this.facingSupplier, side -> side == RelativeSide.BACK, side -> side == RelativeSide.RIGHT);
        this.fluidTank = BasicFluidTank.create((int)10000000, (fluid, automationType) -> automationType == AutomationType.MANUAL || !this.mode, (fluid, automationType) -> automationType == AutomationType.INTERNAL || this.mode, this::isValidFluid, (IContentsListener)recipeCacheListener);
        builder.addTank(this.fluidTank, RelativeSide.BACK, RelativeSide.RIGHT);
        return builder.build();
    }

    private boolean isValidFluid(@NotNull FluidStack fluidStack) {
        return ((RotaryInputRecipeCache)this.getRecipeType().getInputCache()).containsInput(this.level, fluidStack);
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide((Supplier)this.facingSupplier);
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)recipeCacheUnpauseListener);
        builder.addContainer((IEnergyContainer)this.energyContainer, new RelativeSide[]{RelativeSide.BACK});
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide((Supplier)this.facingSupplier);
        BooleanSupplier modeSupplier = this::getMode;
        this.gasInputSlot = ChemicalInventorySlot.rotaryDrain((IChemicalTank)this.chemicalTank, (BooleanSupplier)modeSupplier, (IContentsListener)listener, (int)5, (int)25);
        builder.addSlot((IInventorySlot)this.gasInputSlot, new RelativeSide[]{RelativeSide.BACK});
        this.gasOutputSlot = ChemicalInventorySlot.rotaryFill((IChemicalTank)this.chemicalTank, (BooleanSupplier)modeSupplier, (IContentsListener)listener, (int)5, (int)56);
        builder.addSlot((IInventorySlot)this.gasOutputSlot, new RelativeSide[]{RelativeSide.LEFT});
        this.fluidInputSlot = FluidInventorySlot.rotary((IExtendedFluidTank)this.fluidTank, (BooleanSupplier)modeSupplier, (IContentsListener)listener, (int)155, (int)25);
        builder.addSlot((IInventorySlot)this.fluidInputSlot, new RelativeSide[]{RelativeSide.BACK});
        this.fluidOutputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)155, (int)56);
        builder.addSlot((IInventorySlot)this.fluidOutputSlot, new RelativeSide[]{RelativeSide.RIGHT});
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityLargeRotaryCondensentrator)this).getLevel(), (IContentsListener)listener, (int)155, (int)5);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.BACK});
        this.gasInputSlot.setSlotType(ContainerSlotType.INPUT);
        this.gasInputSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.gasOutputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.gasOutputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.fluidInputSlot.setSlotType(ContainerSlotType.INPUT);
        return builder.build();
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        if (this.mode) {
            this.fluidInputSlot.fillTank((IInventorySlot)this.fluidOutputSlot);
            this.gasInputSlot.drainTank();
        } else {
            this.gasOutputSlot.fillTank();
            this.fluidInputSlot.drainTank((IInventorySlot)this.fluidOutputSlot);
        }
        this.clientEnergyUsed = this.recipeCacheLookupMonitor.updateAndProcess(this.energyContainer);
        this.handleEject();
        return sendUpdatePacket;
    }

    private void handleEject() {
        Direction up;
        if (this.leftOutputCaches == null) {
            this.leftOutputCaches = new ArrayList<BlockCapabilityCache<IChemicalHandler, Direction>>(1);
            Direction left = RelativeSide.LEFT.getDirection(this.getDirection());
            up = RelativeSide.TOP.getDirection(this.getDirection());
            this.leftOutputCaches.add((BlockCapabilityCache<IChemicalHandler, Direction>)Capabilities.CHEMICAL.createCache((ServerLevel)this.level, this.worldPosition.offset(up.getNormal()).offset(this.getLeftSide().getNormal()).relative(left), left.getOpposite()));
        }
        ChemicalUtil.emit(this.leftOutputCaches, (IChemicalTank)this.chemicalTank, (long)this.chemicalTank.getCapacity());
        if (this.rightOutputCaches == null) {
            this.rightOutputCaches = new ArrayList<BlockCapabilityCache<IFluidHandler, Direction>>(1);
            Direction right = RelativeSide.RIGHT.getDirection(this.getDirection());
            up = RelativeSide.TOP.getDirection(this.getDirection());
            this.rightOutputCaches.add((BlockCapabilityCache<IFluidHandler, Direction>)Capabilities.FLUID.createCache((ServerLevel)this.level, this.worldPosition.offset(up.getNormal()).offset(this.getRightSide().getNormal()).relative(right), right.getOpposite()));
        }
        FluidUtils.emit(this.rightOutputCaches, (IExtendedFluidTank)this.fluidTank, (int)this.fluidTank.getCapacity());
    }

    protected void invalidateDirectionCaches(Direction newDirection) {
        super.invalidateDirectionCaches(newDirection);
        this.leftOutputCaches = null;
        this.rightOutputCaches = null;
    }

    public boolean getMode() {
        return this.mode;
    }

    public void nextMode() {
        this.mode = !this.mode;
        this.setChanged();
    }

    public void previousMode() {
        this.nextMode();
    }

    @ComputerMethod(nameOverride="getEnergyUsage", methodDescription="Get the energy used in the last tick by the machine")
    public long getEnergyUsed() {
        return this.clientEnergyUsed;
    }

    public void readSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag data) {
        super.readSustainedData(provider, data);
        NBTUtils.setBooleanIfPresent((CompoundTag)data, (String)"mode", value -> {
            this.mode = value;
        });
    }

    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag data) {
        super.writeSustainedData(provider, data);
        data.putBoolean("mode", this.mode);
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.mode = (Boolean)input.getOrDefault((Supplier)MekanismDataComponents.ROTARY_MODE, (Object)this.mode);
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((Supplier)MekanismDataComponents.ROTARY_MODE, (Object)this.mode);
    }

    public int getRedstoneLevel() {
        if (this.mode) {
            return MekanismUtils.redstoneLevelFromContents((long)this.fluidTank.getFluidAmount(), (long)this.fluidTank.getCapacity());
        }
        return MekanismUtils.redstoneLevelFromContents((long)this.chemicalTank.getStored(), (long)this.chemicalTank.getCapacity());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.FLUID || type == ContainerType.CHEMICAL;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<RotaryRecipeInput, RotaryRecipe, RotaryInputRecipeCache> getRecipeType() {
        return MekanismRecipeType.ROTARY;
    }

    @Nullable
    public RotaryRecipe getRecipe(int cacheIndex) {
        RotaryInputRecipeCache inputCache = (RotaryInputRecipeCache)this.getRecipeType().getInputCache();
        return this.mode ? inputCache.findFirstRecipe(this.level, (FluidStack)this.fluidInputHandler.getInput()) : inputCache.findFirstRecipe(this.level, (ChemicalStack)this.chemicalInputHandler.getInput());
    }

    @NotNull
    public CachedRecipe<RotaryRecipe> createNewCachedRecipe(@NotNull RotaryRecipe recipe, int cacheIndex) {
        return new RotaryCachedRecipe(recipe, this.recheckAllRecipeErrors, this.fluidInputHandler, this.chemicalInputHandler, this.chemicalOutputHandler, this.fluidOutputHandler, this::getMode).setErrorsChanged(x$0 -> this.onErrorsChanged((Set)x$0)).setCanHolderFunction(() -> ((TileEntityLargeRotaryCondensentrator)this).canFunction()).setActive(arg_0 -> ((TileEntityLargeRotaryCondensentrator)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setBaselineMaxOperations(() -> this.baseOperations * this.baselineMaxOperations).setOnFinish(() -> ((TileEntityLargeRotaryCondensentrator)this).markForSave());
    }

    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            int upgradeCount = this.upgradeComponent.getUpgrades(Upgrade.SPEED);
            this.baseOperations = 4 * (upgradeCount > 0 ? upgradeCount : upgradeCount + 1);
            this.baselineMaxOperations = (int)Math.pow(2.0, upgradeCount);
        }
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableBoolean.create(this::getMode, value -> {
            this.mode = value;
        }));
        container.track((ISyncableData)SyncableLong.create(this::getEnergyUsed, value -> {
            this.clientEnergyUsed = value;
        }));
    }

    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    public void onBoundingBlockPowerChange(BlockPos boundingPos, int oldLevel, int newLevel) {
        if (oldLevel > 0) {
            if (newLevel == 0) {
                --this.numPowering;
            }
        } else if (newLevel > 0) {
            ++this.numPowering;
        }
    }

    public int getBoundingComparatorSignal(Vec3i offset) {
        Direction front = this.getDirection();
        Direction back = this.getOppositeDirection();
        Direction left = this.getLeftSide();
        Direction right = this.getRightSide();
        if (offset.equals((Object)new Vec3i(back.getStepX(), 0, back.getStepZ()))) {
            return this.getCurrentRedstoneLevel();
        }
        switch (front) {
            case NORTH: 
            case SOUTH: {
                if (!offset.equals((Object)new Vec3i(left.getStepX(), 0, back.getStepZ())) && !offset.equals((Object)new Vec3i(right.getStepX(), 0, back.getStepZ()))) break;
                return this.getCurrentRedstoneLevel();
            }
            case WEST: 
            case EAST: {
                if (!offset.equals((Object)new Vec3i(back.getStepX(), 0, left.getStepZ())) && !offset.equals((Object)new Vec3i(back.getStepX(), 0, right.getStepZ()))) break;
                return this.getCurrentRedstoneLevel();
            }
        }
        return 0;
    }

    @Nullable
    public <T> T getOffsetCapabilityIfEnabled(@NotNull BlockCapability<T, @Nullable Direction> capability, Direction side, @NotNull Vec3i offset) {
        if (capability == Capabilities.CHEMICAL.block()) {
            return (T)Objects.requireNonNull(this.chemicalHandlerManager, "Expected to have chemical handler").resolve(capability, side);
        }
        if (capability == Capabilities.FLUID.block()) {
            return (T)Objects.requireNonNull(this.fluidHandlerManager, "Expected to have fluid handler").resolve(capability, side);
        }
        if (capability == Capabilities.ENERGY.block()) {
            return (T)Objects.requireNonNull(this.energyHandlerManager, "Expected to have energy handler").resolve(capability, side);
        }
        if (capability == Capabilities.ITEM.block()) {
            return (T)Objects.requireNonNull(this.itemHandlerManager, "Expected to have item handler").resolve(capability, side);
        }
        return (T)WorldUtils.getCapability((Level)this.level, capability, (BlockPos)this.worldPosition, null, (BlockEntity)this, (Object)side);
    }

    public boolean isOffsetCapabilityDisabled(@NotNull BlockCapability<?, @Nullable Direction> capability, Direction side, @NotNull Vec3i offset) {
        if (capability == Capabilities.CHEMICAL.block()) {
            return this.notChemicalPort(side, offset);
        }
        if (capability == Capabilities.FLUID.block()) {
            return this.notFluidPort(side, offset);
        }
        if (EnergyCompatUtils.isEnergyCapability(capability)) {
            return this.notEnergyPort(side, offset);
        }
        if (capability == Capabilities.ITEM.block()) {
            return this.notItemPort(side, offset);
        }
        return this.notChemicalPort(side, offset) && this.notFluidPort(side, offset) && this.notEnergyPort(side, offset);
    }

    private boolean notChemicalPort(Direction side, Vec3i offset) {
        Direction front = this.getDirection();
        Direction back = this.getOppositeDirection();
        Direction left = this.getLeftSide();
        if (offset.equals((Object)new Vec3i(left.getStepX(), 1, left.getStepZ()))) {
            return side != left;
        }
        switch (front) {
            case NORTH: 
            case SOUTH: {
                if (!offset.equals((Object)new Vec3i(left.getStepX(), 0, back.getStepZ()))) break;
                return side != back;
            }
            case WEST: 
            case EAST: {
                if (!offset.equals((Object)new Vec3i(back.getStepX(), 0, left.getStepZ()))) break;
                return side != back;
            }
        }
        return true;
    }

    private boolean notFluidPort(Direction side, Vec3i offset) {
        Direction front = this.getDirection();
        Direction back = this.getOppositeDirection();
        Direction right = this.getRightSide();
        if (offset.equals((Object)new Vec3i(right.getStepX(), 1, right.getStepZ()))) {
            return side != right;
        }
        switch (front) {
            case NORTH: 
            case SOUTH: {
                if (!offset.equals((Object)new Vec3i(right.getStepX(), 0, back.getStepZ()))) break;
                return side != back;
            }
            case WEST: 
            case EAST: {
                if (!offset.equals((Object)new Vec3i(back.getStepX(), 0, right.getStepZ()))) break;
                return side != back;
            }
        }
        return true;
    }

    private boolean notItemPort(Direction side, Vec3i offset) {
        return this.notChemicalPort(side, offset) && this.notFluidPort(side, offset) && this.notEnergyPort(side, offset);
    }

    private boolean notEnergyPort(Direction side, Vec3i offset) {
        Direction back = this.getOppositeDirection();
        if (offset.equals((Object)new Vec3i(back.getStepX(), 0, back.getStepZ()))) {
            return side != back;
        }
        return true;
    }

    @ComputerMethod
    boolean isCondensentrating() {
        return !this.mode;
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setCondensentrating(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.mode != value) {
            this.mode = value;
            this.setChanged();
        }
    }

    @Generated
    public MachineEnergyContainer<TileEntityLargeRotaryCondensentrator> getEnergyContainer() {
        return this.energyContainer;
    }
}

