/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockPosData
extends AbstractData<BlockPos>
implements IContainerData {
    private int _lastHash;

    public static BlockPosData immutable(ModContainer container, BlockPos value) {
        return BlockPosData.of(container, () -> value, CodeHelper.emptyConsumer());
    }

    public static BlockPosData sampled(int frequency, ModContainer container, Supplier<@NotNull BlockPos> getter, Consumer<@NotNull BlockPos> clientSideSetter) {
        return BlockPosData.of(container, new Sampler<BlockPos>(frequency, getter), clientSideSetter);
    }

    public static BlockPosData sampled(int frequency, ModContainer container, Supplier<@NotNull BlockPos> getter) {
        return BlockPosData.of(container, new Sampler<BlockPos>(frequency, getter), CodeHelper.emptyConsumer());
    }

    public static BlockPosData of(ModContainer container, Supplier<@NotNull BlockPos> getter, Consumer<@NotNull BlockPos> clientSideSetter) {
        Preconditions.checkNotNull((Object)((Object)container), (Object)"Container must not be null.");
        BlockPosData data = container.isClientSide() ? new BlockPosData(getter, clientSideSetter) : new BlockPosData(getter);
        container.addBindableData(data);
        return data;
    }

    public static BlockPosData of(ModContainer container, Supplier<@NotNull BlockPos> getter) {
        return BlockPosData.of(container, getter, CodeHelper.emptyConsumer());
    }

    @Override
    @Nullable
    public ISyncedSetEntry getChangedValue() {
        BlockPos current = (BlockPos)this.getValue();
        int currentHash = current.hashCode();
        if (this._lastHash != currentHash) {
            this._lastHash = currentHash;
            return new BlockPosEntry(current);
        }
        return null;
    }

    @Override
    public ISyncedSetEntry getValueFrom(RegistryFriendlyByteBuf buffer) {
        return BlockPosEntry.from(buffer);
    }

    @Override
    public void updateFrom(ISyncedSetEntry entry) {
        if (entry instanceof BlockPosEntry) {
            BlockPosEntry record = (BlockPosEntry)entry;
            this.setClientSideValue(record.value);
            this.notify(record.value);
        }
    }

    @Override
    @Nullable
    public BlockPos defaultValue() {
        return BlockPos.ZERO;
    }

    private BlockPosData(Supplier<BlockPos> getter, Consumer<BlockPos> clientSideSetter) {
        super(getter, clientSideSetter);
    }

    private BlockPosData(Supplier<BlockPos> getter) {
        super(getter);
        this._lastHash = 0;
    }

    private record BlockPosEntry(BlockPos value) implements ISyncedSetEntry
    {
        private static BlockPosEntry from(RegistryFriendlyByteBuf buffer) {
            return new BlockPosEntry(buffer.readBlockPos());
        }

        @Override
        public void accept(@NotNull RegistryFriendlyByteBuf buffer) {
            buffer.writeBlockPos(this.value);
        }
    }
}

