/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.stack;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.DynamicOps;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.stack.IStackAdapter;
import it.zerono.mods.zerocore.lib.energy.EnergyStack;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.WideEnergyStack;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public final class StackAdapters {
    public static final IStackAdapter<ItemStack, Item> ITEMSTACK = new IStackAdapter<ItemStack, Item>(){

        @Override
        public Optional<Item> getContent(ItemStack stack) {
            return !stack.isEmpty() ? Optional.of(stack.getItem()) : Optional.empty();
        }

        @Override
        public int getAmount(ItemStack stack) {
            return stack.getCount();
        }

        @Override
        public ItemStack setAmount(ItemStack stack, int amount) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.setCount(amount);
            return stack;
        }

        @Override
        public ItemStack modifyAmount(ItemStack stack, int delta) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.grow(delta);
            return stack;
        }

        @Override
        public ItemStack getEmptyStack() {
            return ItemStack.EMPTY;
        }

        @Override
        public boolean isEmpty(ItemStack stack) {
            return stack.isEmpty();
        }

        @Override
        public boolean isStackContentEqual(ItemStack stack1, ItemStack stack2) {
            return ItemStack.isSameItem((ItemStack)stack1, (ItemStack)stack2);
        }

        @Override
        public boolean isContentEqual(Item content1, Item content2) {
            return content1 == content2;
        }

        @Override
        public boolean areIdentical(ItemStack stack1, ItemStack stack2) {
            return ItemStack.matches((ItemStack)stack1, (ItemStack)stack2);
        }

        @Override
        public ItemStack create(Item content, int amount) {
            return new ItemStack((ItemLike)content, amount);
        }

        @Override
        public ItemStack create(ItemStack stack) {
            return stack.copy();
        }

        public ItemStack[] createArray(int length) {
            return new ItemStack[length];
        }

        @Override
        public List<ItemStack> createList() {
            return Lists.newArrayList();
        }

        @Override
        public Set<ItemStack> createSet() {
            return Sets.newHashSet();
        }

        @Override
        public ItemStack deserialize(HolderLookup.Provider registries, Tag input) {
            return ItemHelper.stackDeserializeFromNBT(registries, input);
        }

        @Override
        public Tag serialize(HolderLookup.Provider registries, ItemStack stack) {
            return ItemHelper.stackSerializeToNBT(registries, stack);
        }

        @Override
        public Tag serialize(HolderLookup.Provider registries, ItemStack stack, Tag prefix) {
            return ItemHelper.stackSerializeToNBT(registries, stack, prefix);
        }

        @Override
        public String toString(ItemStack stack) {
            return stack.toString();
        }

        @Override
        public <T> T map(ItemStack stack, Function<Item, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getItem());
        }

        @Override
        public <T> T map(ItemStack stack, IntFunction<T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getCount());
        }

        @Override
        public <T> T map(ItemStack stack, BiFunction<Item, Integer, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getItem(), stack.getCount());
        }

        @Override
        public void accept(ItemStack stack, Consumer<Item> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getItem());
            }
        }

        @Override
        public void accept(ItemStack stack, IntConsumer consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getCount());
            }
        }

        @Override
        public void accept(ItemStack stack, BiConsumer<Item, Integer> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getItem(), stack.getCount());
            }
        }
    };
    public static final IStackAdapter<FluidStack, Fluid> FLUIDSTACK = new IStackAdapter<FluidStack, Fluid>(){

        @Override
        public Optional<Fluid> getContent(FluidStack stack) {
            return !stack.isEmpty() ? Optional.of(stack.getFluid()) : Optional.empty();
        }

        @Override
        public int getAmount(FluidStack stack) {
            return stack.getAmount();
        }

        @Override
        public FluidStack setAmount(FluidStack stack, int amount) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.setAmount(amount);
            return stack;
        }

        @Override
        public FluidStack modifyAmount(FluidStack stack, int delta) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.grow(delta);
            return stack;
        }

        @Override
        public FluidStack getEmptyStack() {
            return FluidStack.EMPTY;
        }

        @Override
        public boolean isEmpty(FluidStack stack) {
            return stack.isEmpty();
        }

        @Override
        public boolean isStackContentEqual(FluidStack stack1, FluidStack stack2) {
            return FluidStack.isSameFluidSameComponents((FluidStack)stack1, (FluidStack)stack2);
        }

        @Override
        public boolean isContentEqual(Fluid content1, Fluid content2) {
            return content1.isSame(content2);
        }

        @Override
        public boolean areIdentical(FluidStack stack1, FluidStack stack2) {
            return FluidStack.matches((FluidStack)stack1, (FluidStack)stack2);
        }

        @Override
        public FluidStack create(Fluid content, int amount) {
            return new FluidStack(content, amount);
        }

        @Override
        public FluidStack create(FluidStack stack) {
            return stack.copy();
        }

        public FluidStack[] createArray(int length) {
            return new FluidStack[length];
        }

        @Override
        public List<FluidStack> createList() {
            return Lists.newArrayList();
        }

        @Override
        public Set<FluidStack> createSet() {
            return Sets.newHashSet();
        }

        @Override
        public FluidStack deserialize(HolderLookup.Provider registries, Tag input) {
            return FluidHelper.stackDeserializeFromNBT(registries, input);
        }

        @Override
        public Tag serialize(HolderLookup.Provider registries, FluidStack stack) {
            return FluidHelper.stackSerializeToNBT(registries, stack);
        }

        @Override
        public Tag serialize(HolderLookup.Provider registries, FluidStack stack, Tag prefix) {
            return FluidHelper.stackSerializeToNBT(registries, stack, prefix);
        }

        @Override
        public String toString(FluidStack stack) {
            return stack.getAmount() + " " + String.valueOf(stack.getFluid());
        }

        @Override
        public <T> T map(FluidStack stack, Function<Fluid, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getFluid());
        }

        @Override
        public <T> T map(FluidStack stack, IntFunction<T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getAmount());
        }

        @Override
        public <T> T map(FluidStack stack, BiFunction<Fluid, Integer, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getFluid(), stack.getAmount());
        }

        @Override
        public void accept(FluidStack stack, Consumer<Fluid> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getFluid());
            }
        }

        @Override
        public void accept(FluidStack stack, IntConsumer consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getAmount());
            }
        }

        @Override
        public void accept(FluidStack stack, BiConsumer<Fluid, Integer> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getFluid(), stack.getAmount());
            }
        }
    };
    @Deprecated
    public static final IStackAdapter<EnergyStack, EnergySystem> ENERGYSTACK = new IStackAdapter<EnergyStack, EnergySystem>(){

        @Override
        public Optional<EnergySystem> getContent(EnergyStack stack) {
            return !stack.isEmpty() ? Optional.of(stack.getEnergySystem()) : Optional.empty();
        }

        @Override
        public int getAmount(EnergyStack stack) {
            return (int)stack.getAmount();
        }

        @Override
        public EnergyStack setAmount(EnergyStack stack, int amount) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.setAmount(amount);
            return stack;
        }

        @Override
        public EnergyStack modifyAmount(EnergyStack stack, int delta) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.grow(delta);
            return stack;
        }

        @Override
        public EnergyStack getEmptyStack() {
            return EnergyStack.EMPTY;
        }

        @Override
        public boolean isEmpty(EnergyStack stack) {
            return stack.isEmpty();
        }

        @Override
        public boolean isStackContentEqual(EnergyStack stack1, EnergyStack stack2) {
            return stack1.isEnergySystemEqual(stack2);
        }

        @Override
        public boolean isContentEqual(EnergySystem content1, EnergySystem content2) {
            return content1 == content2;
        }

        @Override
        public boolean areIdentical(EnergyStack stack1, EnergyStack stack2) {
            return EnergyStack.areItemStacksEqual(stack1, stack2);
        }

        @Override
        public EnergyStack create(EnergySystem content, int amount) {
            return new EnergyStack(content, amount);
        }

        @Override
        public EnergyStack create(EnergyStack stack) {
            return stack.copy();
        }

        public EnergyStack[] createArray(int length) {
            return new EnergyStack[length];
        }

        @Override
        public List<EnergyStack> createList() {
            return Lists.newArrayList();
        }

        @Override
        public Set<EnergyStack> createSet() {
            return Sets.newHashSet();
        }

        @Override
        public EnergyStack deserialize(HolderLookup.Provider registries, Tag input) {
            if (input instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)input;
                return EnergyStack.from(compound);
            }
            throw new IllegalArgumentException("Input must be a CompoundTag instance");
        }

        @Override
        public Tag serialize(HolderLookup.Provider registries, EnergyStack stack) {
            return stack.serializeTo(new CompoundTag());
        }

        @Override
        public Tag serialize(HolderLookup.Provider registries, EnergyStack stack, Tag prefix) {
            CompoundTag prefixedCompound;
            CompoundTag output = new CompoundTag();
            if (prefix instanceof CompoundTag && !(prefixedCompound = (CompoundTag)prefix).isEmpty()) {
                output.merge(prefixedCompound);
            }
            return stack.serializeTo(output);
        }

        @Override
        public String toString(EnergyStack stack) {
            return stack.toString();
        }

        @Override
        public <T> T map(EnergyStack stack, Function<EnergySystem, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getEnergySystem());
        }

        @Override
        public <T> T map(EnergyStack stack, IntFunction<T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply((int)stack.getAmount());
        }

        @Override
        public <T> T map(EnergyStack stack, BiFunction<EnergySystem, Integer, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getEnergySystem(), (int)stack.getAmount());
        }

        @Override
        public void accept(EnergyStack stack, Consumer<EnergySystem> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getEnergySystem());
            }
        }

        @Override
        public void accept(EnergyStack stack, IntConsumer consumer) {
            if (!stack.isEmpty()) {
                consumer.accept((int)stack.getAmount());
            }
        }

        @Override
        public void accept(EnergyStack stack, BiConsumer<EnergySystem, Integer> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getEnergySystem(), (int)stack.getAmount());
            }
        }
    };
    public static final IStackAdapter<WideEnergyStack, EnergySystem> WIDEENERGYSTACK = new IStackAdapter<WideEnergyStack, EnergySystem>(){

        @Override
        public Optional<EnergySystem> getContent(WideEnergyStack stack) {
            return !stack.isEmpty() ? Optional.of(stack.getEnergySystem()) : Optional.empty();
        }

        @Override
        public int getAmount(WideEnergyStack stack) {
            return stack.getAmount().intValue();
        }

        @Override
        public WideEnergyStack setAmount(WideEnergyStack stack, int amount) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.setAmount(WideAmount.from(amount));
            return stack;
        }

        @Override
        public WideEnergyStack modifyAmount(WideEnergyStack stack, int delta) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.grow(WideAmount.from(delta));
            return stack;
        }

        @Override
        public WideEnergyStack getEmptyStack() {
            return WideEnergyStack.EMPTY;
        }

        @Override
        public boolean isEmpty(WideEnergyStack stack) {
            return stack.isEmpty();
        }

        @Override
        public boolean isStackContentEqual(WideEnergyStack stack1, WideEnergyStack stack2) {
            return stack1.isEnergySystemEqual(stack2);
        }

        @Override
        public boolean isContentEqual(EnergySystem content1, EnergySystem content2) {
            return content1 == content2;
        }

        @Override
        public boolean areIdentical(WideEnergyStack stack1, WideEnergyStack stack2) {
            return WideEnergyStack.areStacksEqual(stack1, stack2);
        }

        @Override
        public WideEnergyStack create(EnergySystem content, int amount) {
            return new WideEnergyStack(content, WideAmount.from(amount));
        }

        @Override
        public WideEnergyStack create(WideEnergyStack stack) {
            return stack.copy();
        }

        public WideEnergyStack[] createArray(int length) {
            return new WideEnergyStack[length];
        }

        @Override
        public List<WideEnergyStack> createList() {
            return Lists.newArrayList();
        }

        @Override
        public Set<WideEnergyStack> createSet() {
            return Sets.newHashSet();
        }

        @Override
        public WideEnergyStack deserialize(HolderLookup.Provider registries, Tag input) {
            return WideEnergyStack.CODECS.codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)input).result().orElse(WideEnergyStack.EMPTY);
        }

        @Override
        public Tag serialize(HolderLookup.Provider registries, WideEnergyStack stack) {
            return WideEnergyStack.CODECS.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)stack).result().orElseGet(CompoundTag::new);
        }

        @Override
        public Tag serialize(HolderLookup.Provider registries, WideEnergyStack stack, Tag prefix) {
            return WideEnergyStack.CODECS.codec().encode((Object)stack, (DynamicOps)NbtOps.INSTANCE, (Object)prefix).result().orElseGet(CompoundTag::new);
        }

        @Override
        public String toString(WideEnergyStack stack) {
            return stack.toString();
        }

        @Override
        public <T> T map(WideEnergyStack stack, Function<EnergySystem, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getEnergySystem());
        }

        @Override
        public <T> T map(WideEnergyStack stack, IntFunction<T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getAmount().intValue());
        }

        @Override
        public <T> T map(WideEnergyStack stack, BiFunction<EnergySystem, Integer, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getEnergySystem(), stack.getAmount().intValue());
        }

        @Override
        public void accept(WideEnergyStack stack, Consumer<EnergySystem> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getEnergySystem());
            }
        }

        @Override
        public void accept(WideEnergyStack stack, IntConsumer consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getAmount().intValue());
            }
        }

        @Override
        public void accept(WideEnergyStack stack, BiConsumer<EnergySystem, Integer> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getEnergySystem(), stack.getAmount().intValue());
            }
        }
    };

    private StackAdapters() {
    }

    private static <StackType, ContentType> void validateNotEmpty(IStackAdapter<StackType, ContentType> adapter, StackType stack) {
        if (adapter.getEmptyStack() == stack) {
            throw new IllegalArgumentException("Attempt to modify an empty stack blocked");
        }
    }
}

