/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.robit;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import mekanism.api.robit.RobitSkin;
import mekanism.api.security.IEntitySecurityUtils;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.entity.EntityRobit;
import mekanism.common.entity.RobitPrideSkinData;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.registries.MekanismRobitSkins;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketRobitName(int entityId, String name) implements IMekanismPacket
{
    public static final int MAX_NAME_LENGTH = 50;
    public static final CustomPacketPayload.Type<PacketRobitName> TYPE = new CustomPacketPayload.Type(Mekanism.rl("robit_name"));
    public static final StreamCodec<ByteBuf, PacketRobitName> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, PacketRobitName::entityId, (StreamCodec)ByteBufCodecs.stringUtf8((int)50), PacketRobitName::name, PacketRobitName::new);
    private static final Map<String, List<ResourceKey<RobitSkin>>> EASTER_EGGS = Map.of("sara", PacketRobitName.getPrideSkins(RobitPrideSkinData.TRANS, RobitPrideSkinData.LESBIAN));

    public PacketRobitName(EntityRobit robit, String name) {
        this(robit.getId(), name);
    }

    public PacketRobitName {
        name = name.trim();
    }

    private static List<ResourceKey<RobitSkin>> getPrideSkins(RobitPrideSkinData ... prideSkinData) {
        return Stream.of(prideSkinData).map(MekanismRobitSkins.PRIDE_SKINS::get).toList();
    }

    @NotNull
    public CustomPacketPayload.Type<PacketRobitName> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        EntityRobit robit;
        if (!PacketRobitName.hasContent(this.name)) {
            return;
        }
        Player player = context.player();
        Entity entity = player.level().getEntity(this.entityId);
        if (entity instanceof EntityRobit && IEntitySecurityUtils.INSTANCE.canAccess(player, robit = (EntityRobit)entity)) {
            Optional randomSkin;
            robit.setCustomName((Component)TextComponentUtil.getString(this.name));
            if (robit.getSkin() == MekanismRobitSkins.BASE && (randomSkin = Util.getRandomSafe(EASTER_EGGS.getOrDefault(this.name.toLowerCase(Locale.ROOT), Collections.emptyList()), (RandomSource)robit.level().random)).isPresent()) {
                robit.setSkin((ResourceKey<RobitSkin>)((ResourceKey)randomSkin.get()), null);
            }
        }
    }

    public static boolean hasContent(String text) {
        if (!text.isEmpty()) {
            boolean wasColorSymbol = false;
            for (char c : text.toCharArray()) {
                if (c == '\u00a7') {
                    wasColorSymbol = true;
                    continue;
                }
                if (!wasColorSymbol) {
                    return true;
                }
                wasColorSymbol = false;
            }
        }
        return false;
    }
}

