/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.advancements.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Optional;
import mekanism.api.tier.BaseTier;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UseTierInstallerTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, BaseTier tier) {
        this.trigger(player, instance -> instance.action == TierUsed.ANY || instance.action.baseTier == tier);
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, TierUsed action) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)TierUsed.CODEC.fieldOf("action").forGetter(TriggerInstance::action)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> any() {
            return MekanismCriteriaTriggers.USE_TIER_INSTALLER.createCriterion(new TriggerInstance(Optional.empty(), TierUsed.ANY));
        }
    }

    public static enum TierUsed implements StringRepresentable
    {
        ANY(null),
        BASIC(BaseTier.BASIC),
        ADVANCED(BaseTier.ADVANCED),
        ELITE(BaseTier.ELITE),
        ULTIMATE(BaseTier.ULTIMATE);

        public static final Codec<TierUsed> CODEC;
        @Nullable
        final BaseTier baseTier;

        private TierUsed(BaseTier baseTier) {
            this.baseTier = baseTier;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(TierUsed::values);
        }
    }
}

