/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.vanilla_input;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.vanilla_input.FluidChemicalRecipeInput;
import net.neoforged.neoforge.fluids.FluidStack;

@NothingNullByDefault
public record SingleFluidChemicalRecipeInput(FluidStack fluid, ChemicalStack chemical) implements FluidChemicalRecipeInput
{
    @Override
    public FluidStack getFluid(int index) {
        if (index != 0) {
            throw new IllegalArgumentException("No fluid for index " + index);
        }
        return this.fluid;
    }

    @Override
    public ChemicalStack getChemical(int index) {
        if (index != 0) {
            throw new IllegalArgumentException("No chemical for index " + index);
        }
        return this.chemical;
    }

    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.fluid.isEmpty() || this.chemical.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleFluidChemicalRecipeInput other = (SingleFluidChemicalRecipeInput)o;
        return this.chemical.equals(other.chemical) && FluidStack.matches((FluidStack)this.fluid, (FluidStack)other.fluid);
    }

    @Override
    public int hashCode() {
        int hash = this.chemical.hashCode();
        hash = 31 * hash + FluidStack.hashFluidAndComponents((FluidStack)this.fluid);
        hash = 31 * hash + this.fluid.getAmount();
        return hash;
    }
}

