/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.datagen.data.recipe.enderio;

import com.enderio.machines.common.recipe.AlloySmeltingRecipe;
import com.enderio.machines.data.recipes.AlloyRecipeProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.allthemods.alltheores.registry.ATORegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class ATOEIOAlloySmelterRecipeProvider
extends AlloyRecipeProvider
implements IConditionBuilder {
    private static final int ALLOY_SMELTER_ENERGY = 4800;

    public ATOEIOAlloySmelterRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, registries);
    }

    private ResourceLocation alloySmeltingDir(String type) {
        return ResourceLocation.fromNamespaceAndPath((String)"alltheores", (String)("alloy_smelting/" + type));
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        this.alloySmelter(new ItemStack((ItemLike)ATORegistry.STEEL.INGOT.get()), List.of(SizedIngredient.of(ATORegistry.IRON.INGOT_TAG, (int)1), SizedIngredient.of((TagKey)ItemTags.COALS, (int)1)), 4800, 0.3f, recipeOutput);
        this.alloySmelter(new ItemStack((ItemLike)ATORegistry.INVAR.INGOT.get(), 3), List.of(SizedIngredient.of(ATORegistry.IRON.INGOT_TAG, (int)2), SizedIngredient.of((TagKey)ATORegistry.NICKEL.INGOT_TAG, (int)1)), 4800, 0.3f, recipeOutput);
        this.alloySmelter(new ItemStack((ItemLike)ATORegistry.ELECTRUM.INGOT.get(), 2), List.of(SizedIngredient.of(ATORegistry.GOLD.INGOT_TAG, (int)1), SizedIngredient.of((TagKey)ATORegistry.SILVER.INGOT_TAG, (int)1)), 4800, 0.3f, recipeOutput);
        this.alloySmelter(new ItemStack((ItemLike)ATORegistry.BRONZE.INGOT.get(), 4), List.of(SizedIngredient.of(ATORegistry.COPPER.INGOT_TAG, (int)3), SizedIngredient.of((TagKey)ATORegistry.TIN.INGOT_TAG, (int)1)), 4800, 0.3f, recipeOutput);
        this.alloySmelter(new ItemStack((ItemLike)ATORegistry.BRASS.INGOT.get(), 4), List.of(SizedIngredient.of(ATORegistry.COPPER.INGOT_TAG, (int)3), SizedIngredient.of((TagKey)ATORegistry.ZINC.INGOT_TAG, (int)1)), 4800, 0.3f, recipeOutput);
        this.alloySmelter(new ItemStack((ItemLike)ATORegistry.ENDERIUM.INGOT.get(), 4), List.of(SizedIngredient.of((TagKey)ATORegistry.LEAD.INGOT_TAG, (int)3), SizedIngredient.of((TagKey)ATORegistry.PLATINUM.INGOT_TAG, (int)1), SizedIngredient.of((TagKey)Tags.Items.ENDER_PEARLS, (int)2)), 4800, 0.3f, recipeOutput);
        this.alloySmelter(new ItemStack((ItemLike)ATORegistry.LUMIUM.INGOT.get(), 4), List.of(SizedIngredient.of((TagKey)Tags.Items.DUSTS_GLOWSTONE, (int)4), SizedIngredient.of((TagKey)ATORegistry.SILVER.INGOT_TAG, (int)1), SizedIngredient.of((TagKey)ATORegistry.TIN.INGOT_TAG, (int)3)), 4800, 0.3f, recipeOutput);
        this.alloySmelter(new ItemStack((ItemLike)ATORegistry.SIGNALUM.INGOT.get(), 4), List.of(SizedIngredient.of(ATORegistry.COPPER.INGOT_TAG, (int)3), SizedIngredient.of((TagKey)ATORegistry.SILVER.INGOT_TAG, (int)1), SizedIngredient.of((TagKey)Tags.Items.DUSTS_REDSTONE, (int)4)), 4800, 0.3f, recipeOutput);
        this.alloySmelter(new ItemStack((ItemLike)ATORegistry.CONSTANTAN.INGOT.get(), 2), List.of(SizedIngredient.of(ATORegistry.COPPER.INGOT_TAG, (int)1), SizedIngredient.of((TagKey)ATORegistry.NICKEL.INGOT_TAG, (int)1)), 4800, 0.3f, recipeOutput);
    }

    private void alloySmelter(ItemStack output, List<SizedIngredient> inputs, int energy, float experience, RecipeOutput recipeOutput) {
        recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("enderio_machines")}).accept(this.alloySmeltingDir(BuiltInRegistries.ITEM.getKey((Object)output.getItem()).getPath()), (Recipe)new AlloySmeltingRecipe(inputs, output, energy, experience), null);
    }
}

