/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.content.blocks.sets.ato_sets;

import java.util.ArrayList;
import java.util.List;
import net.allthemods.alltheores.content.blocks.sets.BlockSet;
import net.allthemods.alltheores.content.blocks.sets.ESetTypes;
import net.allthemods.alltheores.infos.Reference;
import net.allthemods.alltheores.registry.ATORegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ATOMaterialSet
extends BlockSet {
    private static final List<ATOMaterialSet> instances = new ArrayList<ATOMaterialSet>();
    public final ESetTypes type;
    public final TagKey<Item> DUST_TAG;
    public final TagKey<Block> BLOCK_TAG;
    public final TagKey<Item> BLOCK_ITEM_TAG;
    public final DeferredHolder<Item, Item> DUST;
    public final DeferredHolder<Block, Block> BLOCK;
    public final DeferredHolder<Item, BlockItem> BLOCK_ITEM;

    public static List<ATOMaterialSet> getMaterialSets() {
        return instances;
    }

    public ATOMaterialSet(String name, ESetTypes type) {
        super(name);
        instances.add(this);
        this.type = type;
        this.DUST_TAG = ItemTags.create((ResourceLocation)Reference.dust(name));
        this.BLOCK_TAG = BlockTags.create((ResourceLocation)Reference.block(name));
        this.BLOCK_ITEM_TAG = ItemTags.create((ResourceLocation)Reference.block(name));
        switch (type) {
            case INGOT: 
            case ALLOY: {
                this.DUST = ATORegistry.item(String.format("%s_dust", name));
                this.BLOCK = ATORegistry.BLOCKS.register(String.format("%s_block", name), () -> new Block(BlockBehaviour.Properties.of().strength(3.0f, 3.0f).sound(SoundType.METAL)));
                break;
            }
            case GEM: {
                this.DUST = ATORegistry.item(String.format("%s_dust", name));
                this.BLOCK = ATORegistry.BLOCKS.register(String.format("%s_block", name), () -> new Block(BlockBehaviour.Properties.of().strength(3.0f, 3.0f).sound(SoundType.AMETHYST)));
                break;
            }
            case DUST: {
                this.DUST = ATORegistry.item(name);
                this.BLOCK = ATORegistry.BLOCKS.register(String.format("%s_block", name), () -> new Block(BlockBehaviour.Properties.of().strength(3.0f, 3.0f).sound(SoundType.AMETHYST)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Type: " + name);
            }
        }
        this.BLOCK_ITEM = ATORegistry.blockItem(this.BLOCK);
    }
}

