/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.network;

import com.hrznstudio.titanium.network.Message;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NetworkHandler {
    private final String namespace;
    private final Map<Class<? extends Message>, ResourceLocation> ids = new HashMap<Class<? extends Message>, ResourceLocation>();
    private final List<Consumer<PayloadRegistrar>> registrar = new ArrayList<Consumer<PayloadRegistrar>>();
    private int i = 0;

    public NetworkHandler(String modid) {
        this.namespace = modid;
        ((ModContainer)ModList.get().getModContainerById(modid).orElseThrow()).getEventBus().addListener(event -> {
            PayloadRegistrar reg = event.registrar(modid).versioned(String.valueOf(this.i));
            this.registrar.forEach(c -> c.accept(reg));
        });
    }

    public <REQ extends Message> void registerMessage(String name, Class<REQ> message) {
        ++this.i;
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)name);
        this.ids.put(message, id);
        this.registrar.add(reg -> reg.playBidirectional(new CustomPacketPayload.Type(id), StreamCodec.of((buffer, payload) -> payload.message.toBytes((RegistryFriendlyByteBuf)buffer), buffer -> {
            try {
                Message req = (Message)message.getConstructor(new Class[0]).newInstance(new Object[0]);
                req.fromBytes((RegistryFriendlyByteBuf)buffer);
                return new MessageWrapper(id, req);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }), (payload, context) -> payload.message.handleMessage(context)));
    }

    public CustomPacketPayload wrap(Message message) {
        return new MessageWrapper(this.ids.get(message.getClass()), message);
    }

    public void sendToNearby(Level world, BlockPos pos, int distance, Message message) {
        world.getEntitiesOfClass(ServerPlayer.class, new AABB(pos).inflate((double)distance)).forEach(playerEntity -> this.sendTo(message, (ServerPlayer)playerEntity));
    }

    public void sendToServer(Message message) {
        PacketDistributor.sendToServer((CustomPacketPayload)this.wrap(message), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendTo(Message message, ServerPlayer player) {
        player.connection.send(this.wrap(message));
    }

    public record MessageWrapper(ResourceLocation id, Message message) implements CustomPacketPayload
    {
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return new CustomPacketPayload.Type(this.id);
        }
    }
}

