/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.common.me.ticker;

import com.glodblock.github.ae2netanalyser.AEAnalyser;
import com.glodblock.github.glodium.client.render.ColorData;
import com.glodblock.github.glodium.util.GlodUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ProfileData {
    public ATick[] ticks;
    private boolean isCorrupt;

    public ProfileData() {
        this.isCorrupt = false;
    }

    public ProfileData(ATick[] ticks) {
        this.ticks = ticks;
        this.isCorrupt = false;
    }

    public boolean isCorrupt() {
        return this.isCorrupt;
    }

    public static ProfileData readBytes(FriendlyByteBuf buf) {
        ProfileData data = new ProfileData();
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream((InputStream)new ByteBufInputStream((ByteBuf)buf))));){
            int len = stream.readInt();
            data.ticks = new ATick[len];
            for (int i = 0; i < len; ++i) {
                ResourceKey dim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)stream.readUTF()));
                BlockPos pos = BlockPos.of((long)stream.readLong());
                double rate = stream.readDouble();
                data.ticks[i] = new ATick(new GlobalPos(dim, pos), rate, ProfileData.getColor(rate));
            }
        }
        catch (Exception e) {
            AEAnalyser.LOGGER.error("Fail to profile ticks. The packet is corrupted!", (Throwable)e);
            data.isCorrupt = true;
        }
        buf.clear();
        return data;
    }

    public static ColorData getColor(double rate) {
        float gradient = (float)GlodUtil.clamp((double)(rate / 100.0), (double)0.0, (double)1.0);
        return new ColorData((float)GlodUtil.clamp((double)gradient, (double)0.07, (double)0.7), gradient, 1.0f - gradient, 0.0f);
    }

    public void writeBytes(FriendlyByteBuf buf) {
        try (DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream((OutputStream)new ByteBufOutputStream((ByteBuf)buf))));){
            stream.writeInt(this.ticks.length);
            for (ATick t : this.ticks) {
                ResourceLocation dim = t.pos.dimension().location();
                BlockPos pos = t.pos.pos();
                double rate = t.rate();
                stream.writeUTF(dim.toString());
                stream.writeLong(pos.asLong());
                stream.writeDouble(rate);
            }
        }
        catch (Exception e) {
            AEAnalyser.LOGGER.error("Fail to profile ticks. The packet is corrupted!", (Throwable)e);
            this.isCorrupt = true;
        }
    }

    public record ATick(GlobalPos pos, double rate, ColorData color) {
        public ATick(GlobalPos pos, double rate) {
            this(pos, rate, new ColorData(1, 1, 1));
        }
    }
}

