/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.menu.screen;

import com.github.flandre923.berrypouch.helper.MarkedSlotsHelper;
import com.github.flandre923.berrypouch.helper.RenderHelper;
import com.github.flandre923.berrypouch.item.BerryPouch;
import com.github.flandre923.berrypouch.item.pouch.BerryPouchType;
import com.github.flandre923.berrypouch.menu.container.AbstractBerryPouchContainer;
import com.github.flandre923.berrypouch.network.ModNetworking;
import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractBerryPouchScreen<T extends AbstractBerryPouchContainer>
extends AbstractContainerScreen<T> {
    protected final BerryPouchType pouchType;
    protected final ResourceLocation texture;
    protected final Minecraft minecraft;
    private static final ResourceLocation STAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"berrypouch", (String)"textures/gui/star.png");
    private static final int STAR_SIZE = 20;

    public AbstractBerryPouchScreen(T menu, Inventory playerInv, Component title, BerryPouchType pouchType, ResourceLocation texture) {
        super(menu, playerInv, title);
        this.pouchType = pouchType;
        this.texture = texture;
        this.minecraft = Minecraft.getInstance();
        this.initUiSettings();
    }

    protected void initUiSettings() {
        this.imageWidth = this.pouchType.getGuiWidth();
        this.imageHeight = this.pouchType.getGuiHeight();
        this.titleLabelX = this.pouchType.getTitleX();
        this.titleLabelY = this.pouchType.getTitleY();
        this.inventoryLabelX = this.pouchType.getInventoryX();
        this.inventoryLabelY = this.pouchType.getInventoryY();
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(gui, mouseX, mouseY, partialTicks);
        super.render(gui, mouseX, mouseY, partialTicks);
        this.renderTooltip(gui, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.renderBackgroundTexture(guiGraphics);
        this.renderSlotPlaceholders(guiGraphics);
        this.renderMarkedSlotIndicators(guiGraphics);
    }

    protected void renderBackgroundTexture(GuiGraphics guiGraphics) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.texture, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderSlotPlaceholders(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.pose();
        for (Slot slot : ((AbstractBerryPouchContainer)this.menu).slots) {
            if (slot.container != ((AbstractBerryPouchContainer)this.menu).getPouchInventory()) continue;
            int itemX = this.leftPos + slot.x;
            int itemY = this.topPos + slot.y;
            if (!slot.hasItem()) {
                ItemStack placeholder = this.getPlaceholderForSlot(slot.getContainerSlot());
                if (placeholder.isEmpty()) continue;
                RenderHelper.renderGuiItemAlpha(placeholder, itemX, itemY, 95, this.minecraft.getItemRenderer());
                continue;
            }
            if (slot.getItem().getCount() != 1) continue;
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 300.0f);
            guiGraphics.drawString(this.minecraft.font, "1", itemX + 11, itemY + 9, 0xFFFFFF);
            poseStack.popPose();
        }
    }

    protected void renderMarkedSlotIndicators(GuiGraphics guiGraphics) {
        ItemStack currentPouchStack = this.findCurrentPouchStack();
        if (currentPouchStack.isEmpty()) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        for (Slot slot : ((AbstractBerryPouchContainer)this.menu).slots) {
            int pouchSlotIndex;
            if (slot.container != ((AbstractBerryPouchContainer)this.menu).getPouchInventory() || !MarkedSlotsHelper.isSlotMarked(currentPouchStack, pouchSlotIndex = slot.getContainerSlot())) continue;
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 299.0f);
            int starX = this.leftPos + slot.x;
            int starY = this.topPos + slot.y;
            guiGraphics.blit(STAR_TEXTURE, starX, starY, 16, 16, 0.0f, 0.0f, 20, 20, 20, 20);
            poseStack.popPose();
        }
    }

    private ItemStack findCurrentPouchStack() {
        SlotEntryReference equippedRef;
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return ItemStack.EMPTY;
        }
        Item targetItem = ((AbstractBerryPouchContainer)this.menu).getPouchStack().getItem();
        if (!(targetItem instanceof BerryPouch)) {
            return ItemStack.EMPTY;
        }
        ItemStack mainHandStack = player.getMainHandItem();
        if (mainHandStack.is(targetItem)) {
            return mainHandStack;
        }
        ItemStack offHandStack = player.getOffhandItem();
        if (offHandStack.is(targetItem)) {
            return offHandStack;
        }
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
        if (capability != null && (equippedRef = capability.getFirstEquipped(targetItem)) != null) {
            return equippedRef.stack();
        }
        return ItemStack.EMPTY;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Slot clickedSlot;
        if (button == 0 && Screen.hasShiftDown() && (clickedSlot = this.hoveredSlot) != null && clickedSlot.container == ((AbstractBerryPouchContainer)this.menu).getPouchInventory()) {
            int pouchSlotIndex = clickedSlot.getContainerSlot();
            ModNetworking.sendToggleMarkSlotPacketToServer(pouchSlotIndex);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected abstract ItemStack getPlaceholderForSlot(int var1);

    public void onClose() {
        super.onClose();
        if (this.minecraft.player != null) {
            this.minecraft.player.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.5f, this.minecraft.player.level().random.nextFloat() * 0.1f + 0.9f);
        }
    }
}

