/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.menu.container;

import com.github.flandre923.berrypouch.ModRegistries;
import com.github.flandre923.berrypouch.helper.PouchItemHelper;
import com.github.flandre923.berrypouch.item.pouch.BerryPouchType;
import com.github.flandre923.berrypouch.menu.container.AbstractBerryPouchContainer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SmallBerryPouchContainer
extends AbstractBerryPouchContainer {
    private final ItemStack pouchStack;

    public SmallBerryPouchContainer(int windowId, Inventory playerInv, ItemStack pouchStack) {
        super((MenuType)ModRegistries.ModMenuTypes.BERRY_POUCH_CONTAINER_24.get(), windowId, playerInv, pouchStack, BerryPouchType.SMALL);
        this.pouchStack = pouchStack;
    }

    public static SmallBerryPouchContainer fromNetwork(int windowId, Inventory inv, FriendlyByteBuf buf) {
        int isHand = buf.readInt();
        ItemStack item = isHand == 0 ? inv.player.getItemInHand(InteractionHand.MAIN_HAND) : (isHand == 1 ? inv.player.getItemInHand(InteractionHand.OFF_HAND) : PouchItemHelper.findBerryPouch(inv.player));
        return new SmallBerryPouchContainer(windowId, inv, item);
    }

    @Override
    protected void addPouchSlots() {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 8; ++col) {
                final int slotIndex = col + row * 8;
                int xPos = 17 + col * 18;
                int yPos = 10 + row * 18;
                this.addSlot(new Slot(this, this.pouchInventory, slotIndex, xPos, yPos){

                    public boolean mayPlace(ItemStack stack) {
                        return BerryPouchType.SMALL.getStorageSlot().matchesSlotItem(slotIndex + 1, stack.getItem());
                    }
                });
            }
        }
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack returnStack = ItemStack.EMPTY;
        Slot clickedSlot = (Slot)this.slots.get(slotIndex);
        if (clickedSlot != null && clickedSlot.hasItem()) {
            ItemStack originalStack = clickedSlot.getItem().copy();
            returnStack = originalStack.copy();
            if (slotIndex < BerryPouchType.SMALL.getSize()) {
                if (!this.moveItemStackTo(originalStack, BerryPouchType.SMALL.getSize(), this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (BerryPouchType.SMALL.getStorageSlot().has(originalStack.getItem())) {
                if (!this.moveItemStackTo(originalStack, 0, BerryPouchType.SMALL.getSize(), false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                clickedSlot.set(ItemStack.EMPTY);
            } else {
                clickedSlot.set(originalStack);
                clickedSlot.setChanged();
            }
            if (originalStack.getCount() == returnStack.getCount()) {
                return ItemStack.EMPTY;
            }
            clickedSlot.onTake(player, originalStack);
        }
        return returnStack;
    }
}

