/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.menu.container;

import com.github.flandre923.berrypouch.ModRegistries;
import com.github.flandre923.berrypouch.helper.PouchItemHelper;
import com.github.flandre923.berrypouch.item.pouch.BerryPouchType;
import com.github.flandre923.berrypouch.menu.container.AbstractBerryPouchContainer;
import com.github.flandre923.berrypouch.menu.slot.SlotLocked;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MediumBerryPouchContainer
extends AbstractBerryPouchContainer {
    private final ItemStack pouchStack;

    public MediumBerryPouchContainer(int windowId, Inventory playerInv, ItemStack pouchStack) {
        super((MenuType)ModRegistries.ModMenuTypes.BERRY_POUCH_CONTAINER_30.get(), windowId, playerInv, pouchStack, BerryPouchType.MEDIUM);
        this.pouchStack = pouchStack;
    }

    public static MediumBerryPouchContainer fromNetwork(int windowId, Inventory inv, FriendlyByteBuf buf) {
        int isHand = buf.readInt();
        ItemStack item = isHand == 0 ? inv.player.getItemInHand(InteractionHand.MAIN_HAND) : (isHand == 1 ? inv.player.getItemInHand(InteractionHand.OFF_HAND) : PouchItemHelper.findBerryPouch(inv.player));
        return new MediumBerryPouchContainer(windowId, inv, item);
    }

    @Override
    protected void addPouchSlots() {
        int slotIndex;
        int col;
        int row;
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 8; ++col) {
                slotIndex = col + row * 8;
                this.addBerrySlot(slotIndex, 11 + col * 18, 16 + row * 18);
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 2; ++col) {
                slotIndex = 24 + row * 2 + col;
                this.addBerrySlot(slotIndex, 163 + col * 18, 16 + row * 18);
            }
        }
    }

    private void addBerrySlot(final int slotIndex, int x, int y) {
        this.addSlot(new Slot(this, this.pouchInventory, slotIndex, x, y){

            public boolean mayPlace(ItemStack stack) {
                return BerryPouchType.MEDIUM.getStorageSlot().matchesSlotItem(slotIndex + 1, stack.getItem());
            }
        });
    }

    @Override
    protected void addPlayerSlots(Inventory playerInv, ItemStack bag) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int index = col + row * 9 + 9;
                this.addSlot(new Slot((Container)playerInv, index, 25 + col * 18, 96 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            if (playerInv.getItem(col) == bag) {
                this.addSlot(new SlotLocked((Container)playerInv, col, 25 + col * 18, 154));
                continue;
            }
            this.addSlot(new Slot((Container)playerInv, col, 25 + col * 18, 154));
        }
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack returnStack = ItemStack.EMPTY;
        Slot clickedSlot = (Slot)this.slots.get(slotIndex);
        if (clickedSlot != null && clickedSlot.hasItem()) {
            ItemStack originalStack = clickedSlot.getItem().copy();
            returnStack = originalStack.copy();
            if (slotIndex < BerryPouchType.MEDIUM.getSize()) {
                if (!this.moveItemStackTo(originalStack, BerryPouchType.MEDIUM.getSize(), this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (BerryPouchType.MEDIUM.getStorageSlot().has(originalStack.getItem())) {
                if (!this.moveItemStackTo(originalStack, 0, BerryPouchType.MEDIUM.getSize(), false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                clickedSlot.set(ItemStack.EMPTY);
            } else {
                clickedSlot.set(originalStack);
                clickedSlot.setChanged();
            }
            if (originalStack.getCount() == returnStack.getCount()) {
                return ItemStack.EMPTY;
            }
            clickedSlot.onTake(player, originalStack);
        }
        return returnStack;
    }
}

