/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.item.pouch;

import com.github.flandre923.berrypouch.item.BerryPouch;
import com.github.flandre923.berrypouch.item.pouch.BerryPouchInventory;
import com.github.flandre923.berrypouch.item.pouch.BerryPouchType;
import com.github.flandre923.berrypouch.menu.container.LargeBerryPouchContainer;
import com.github.flandre923.berrypouch.menu.container.MediumBerryPouchContainer;
import com.github.flandre923.berrypouch.menu.container.SmallBerryPouchContainer;
import dev.architectury.registry.menu.MenuRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BerryPouchManager {
    private static AbstractContainerMenu createMenu(BerryPouchType type, int syncId, Inventory inv, ItemStack pouchStack) {
        switch (type) {
            case SMALL: {
                return new SmallBerryPouchContainer(syncId, inv, pouchStack);
            }
            case MEDIUM: {
                return new MediumBerryPouchContainer(syncId, inv, pouchStack);
            }
            case LARGE: {
                return new LargeBerryPouchContainer(syncId, inv, pouchStack);
            }
        }
        throw new IllegalArgumentException("Unknown pouch type: " + String.valueOf((Object)type));
    }

    public static SimpleContainer getInventory(ItemStack stack, Level level) {
        BerryPouchType type = BerryPouchManager.getPouchType(stack);
        return new BerryPouchInventory(stack, level, type);
    }

    public static boolean isHoldingPouch(Player player, ItemStack pouchStack) {
        if (player == null || pouchStack.isEmpty()) {
            return false;
        }
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        return ItemStack.matches((ItemStack)pouchStack, (ItemStack)mainHand) || ItemStack.matches((ItemStack)pouchStack, (ItemStack)offHand);
    }

    private static BerryPouchType getPouchType(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            throw new IllegalArgumentException("Stack cannot be null or empty");
        }
        Item item = stack.getItem();
        if (!(item instanceof BerryPouch)) {
            throw new IllegalArgumentException("Item must be a BerryPouch");
        }
        BerryPouch berryPouch = (BerryPouch)item;
        return berryPouch.getPouchType();
    }

    public static void openPouchGUI(ServerPlayer player, ItemStack stack, int flag) {
        if (player.level().isClientSide || stack.isEmpty() || !(stack.getItem() instanceof BerryPouch)) {
            return;
        }
        BerryPouchType type = BerryPouchManager.getPouchType(stack);
        MenuRegistry.openExtendedMenu((ServerPlayer)player, (MenuProvider)BerryPouchManager.createMenuProvider(stack, type), buf -> buf.writeInt(flag));
    }

    public static MenuProvider createMenuProvider(final ItemStack stack, final BerryPouchType type) {
        return new MenuProvider(){

            public Component getDisplayName() {
                return stack.getHoverName();
            }

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return BerryPouchManager.createMenu(type, syncId, inv, stack);
            }
        };
    }
}

