/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.item;

import com.github.flandre923.berrypouch.item.IBerryPouchStorage;
import com.github.flandre923.berrypouch.item.StorageSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;

public abstract class AbstractBerryPouchStorageSlot
implements IBerryPouchStorage {
    public final int SIZE;
    protected final ArrayList<StorageSlot> storageSlots;

    public AbstractBerryPouchStorageSlot(int size) {
        this.SIZE = size;
        this.storageSlots = new ArrayList();
        this.initializeSlots();
    }

    protected abstract Item getSlotItemInternal(int var1);

    @Override
    public Item getSlotItem(int slotIndex) {
        return this.getSlotItemInternal(slotIndex);
    }

    private void initializeSlots() {
        int i = 1;
        while (i <= this.SIZE) {
            int finalI = i++;
            Supplier<Item> itemSupplier = () -> this.getSlotItemInternal(finalI);
            this.storageSlots.add(new StorageSlot(itemSupplier));
        }
    }

    @Override
    public List<StorageSlot> getStorageSlots() {
        return this.storageSlots;
    }

    @Override
    public boolean matchesSlotItem(int slotIndex, Item item) {
        if (slotIndex < 1 || slotIndex > this.SIZE) {
            return false;
        }
        StorageSlot slot = this.storageSlots.get(slotIndex - 1);
        return slot.isItem(item);
    }

    @Override
    public boolean has(Item item) {
        for (StorageSlot slot : this.storageSlots) {
            if (!slot.isItem(item)) continue;
            return true;
        }
        return false;
    }
}

