/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.helper;

import com.github.flandre923.berrypouch.ModRegistries;
import com.github.flandre923.berrypouch.component.MarkedSlotsComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public class MarkedSlotsHelper {
    public static List<Integer> getMarkedSlots(ItemStack stack) {
        return (List)stack.getOrDefault((DataComponentType)ModRegistries.ModDataComponentes.MARKED_SLOTS.get(), MarkedSlotsComponent.EMPTY);
    }

    public static void setMarkedSlots(ItemStack stack, List<Integer> markedSlots) {
        stack.set((DataComponentType)ModRegistries.ModDataComponentes.MARKED_SLOTS.get(), Objects.requireNonNullElse(markedSlots, MarkedSlotsComponent.EMPTY));
    }

    public static void addMarkedSlot(ItemStack stack, int slotIndex) {
        List<Integer> currentMarked = MarkedSlotsHelper.getMarkedSlots(stack);
        if (!currentMarked.contains(slotIndex)) {
            ArrayList<Integer> newMarked = new ArrayList<Integer>(currentMarked);
            newMarked.add(slotIndex);
            MarkedSlotsHelper.setMarkedSlots(stack, newMarked);
        }
    }

    public static void removeMarkedSlot(ItemStack stack, int slotIndex) {
        List<Integer> currentMarked = MarkedSlotsHelper.getMarkedSlots(stack);
        if (currentMarked.contains(slotIndex)) {
            ArrayList<Integer> newMarked = new ArrayList<Integer>(currentMarked);
            newMarked.remove((Object)slotIndex);
            MarkedSlotsHelper.setMarkedSlots(stack, newMarked);
        }
    }

    public static void toggleMarkedSlot(ItemStack stack, int slotIndex) {
        List<Integer> currentMarked = MarkedSlotsHelper.getMarkedSlots(stack);
        ArrayList<Integer> newMarked = new ArrayList<Integer>(currentMarked);
        if (newMarked.contains(slotIndex)) {
            newMarked.remove((Object)slotIndex);
        } else {
            newMarked.add(slotIndex);
        }
        MarkedSlotsHelper.setMarkedSlots(stack, newMarked);
    }

    public static boolean isSlotMarked(ItemStack stack, int slotIndex) {
        return MarkedSlotsHelper.getMarkedSlots(stack).contains(slotIndex);
    }
}

