/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.event;

import com.cobblemon.mod.common.item.interactive.PokerodItem;
import com.github.flandre923.berrypouch.helper.MarkedSlotsHelper;
import com.github.flandre923.berrypouch.helper.PouchDataHelper;
import com.github.flandre923.berrypouch.item.BerryPouch;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.common.InteractionEvent;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;

public class FishingRodEventHandler {
    public static void register() {
        InteractionEvent.RIGHT_CLICK_ITEM.register(FishingRodEventHandler::onPlayerUseItem);
    }

    private static CompoundEventResult<ItemStack> onPlayerUseItem(Player player, InteractionHand hand) {
        Object lastUsedRL;
        Optional lastUsedItemOpt;
        ItemStack heldStack = player.getItemInHand(hand);
        Level level = player.level();
        if (level.isClientSide() || !(player instanceof ServerPlayer)) {
            return CompoundEventResult.pass();
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!FishingRodEventHandler.isCobblemonFishingRod(heldStack) || !PouchDataHelper.isAutoBerryEnabled((ServerPlayer)player)) {
            return CompoundEventResult.pass();
        }
        boolean isAttemptingCast = player.fishing == null;
        ItemStack currentBaitStackOnRod = PokerodItem.Companion.getBaitStackOnRod(heldStack);
        if (!currentBaitStackOnRod.isEmpty()) {
            Item rodBaitItem = currentBaitStackOnRod.getItem();
            if (FishingRodEventHandler.isCobblemonBerry(currentBaitStackOnRod)) {
                ItemStack pouchStack;
                ItemContainerContents pouchContents;
                boolean rodBaitExistsInPouch;
                Optional<ItemStack> pouchStackOpt;
                boolean needsSync;
                ResourceLocation rodBaitRL = BuiltInRegistries.ITEM.getKey((Object)rodBaitItem);
                Optional<ResourceLocation> pouchLastUsedRLOpt = PouchDataHelper.getLastUsedBait(FishingRodEventHandler.pouchStackCheck(serverPlayer));
                boolean bl = needsSync = pouchLastUsedRLOpt.isEmpty() || !pouchLastUsedRLOpt.get().equals((Object)rodBaitRL);
                if (needsSync && (pouchStackOpt = FishingRodEventHandler.getEquippedBerryPouch(serverPlayer)).isPresent() && (rodBaitExistsInPouch = (pouchContents = (ItemContainerContents)(pouchStack = pouchStackOpt.get()).getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).stream().anyMatch(stack -> !stack.isEmpty() && stack.is(rodBaitItem)))) {
                    PouchDataHelper.setLastUsedBait(pouchStack, rodBaitItem);
                }
            }
            return CompoundEventResult.pass();
        }
        if (!isAttemptingCast) {
            return CompoundEventResult.pass();
        }
        Optional<ItemStack> pouchStackOpt = FishingRodEventHandler.getEquippedBerryPouch(serverPlayer);
        if (pouchStackOpt.isEmpty()) {
            return CompoundEventResult.pass();
        }
        ItemStack pouchStack = pouchStackOpt.get();
        BerryPouch berryPouch = (BerryPouch)pouchStack.getItem();
        ItemContainerContents currentContents = (ItemContainerContents)pouchStack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        int pouchSize = berryPouch.getSize();
        NonNullList pouchItems = NonNullList.withSize((int)pouchSize, (Object)ItemStack.EMPTY);
        currentContents.copyInto(pouchItems);
        List<Integer> markedSlots = MarkedSlotsHelper.getMarkedSlots(pouchStack);
        boolean hasMarkedSlots = !markedSlots.isEmpty();
        int foundSlotIndex = -1;
        ItemStack baitToUse = ItemStack.EMPTY;
        Item usedBaitItem = null;
        Optional<ResourceLocation> lastUsedBaitRLOpt = PouchDataHelper.getLastUsedBait(pouchStack);
        if (lastUsedBaitRLOpt.isPresent() && (lastUsedItemOpt = BuiltInRegistries.ITEM.getOptional((ResourceLocation)(lastUsedRL = lastUsedBaitRLOpt.get()))).isPresent()) {
            Item lastUsedItem = (Item)lastUsedItemOpt.get();
            if (hasMarkedSlots) {
                for (int markedIndex : markedSlots) {
                    ItemStack stackInSlot;
                    if (markedIndex < 0 || markedIndex >= pouchItems.size() || (stackInSlot = (ItemStack)pouchItems.get(markedIndex)).isEmpty() || !stackInSlot.is(lastUsedItem) || !FishingRodEventHandler.isCobblemonBerry(stackInSlot)) continue;
                    foundSlotIndex = markedIndex;
                    baitToUse = stackInSlot;
                    usedBaitItem = lastUsedItem;
                    break;
                }
            }
            if (foundSlotIndex == -1) {
                for (int i = 0; i < pouchItems.size(); ++i) {
                    ItemStack stackInSlot = (ItemStack)pouchItems.get(i);
                    if (stackInSlot.isEmpty() || !stackInSlot.is(lastUsedItem) || !FishingRodEventHandler.isCobblemonBerry(stackInSlot)) continue;
                    foundSlotIndex = i;
                    baitToUse = stackInSlot;
                    usedBaitItem = lastUsedItem;
                    break;
                }
            }
        }
        if (foundSlotIndex == -1 && hasMarkedSlots) {
            lastUsedRL = markedSlots.iterator();
            while (lastUsedRL.hasNext()) {
                ItemStack stackInSlot;
                int markedIndex = (Integer)lastUsedRL.next();
                if (markedIndex < 0 || markedIndex >= pouchItems.size() || (stackInSlot = (ItemStack)pouchItems.get(markedIndex)).isEmpty() || !FishingRodEventHandler.isCobblemonBerry(stackInSlot)) continue;
                foundSlotIndex = markedIndex;
                baitToUse = stackInSlot;
                usedBaitItem = stackInSlot.getItem();
                break;
            }
            if (foundSlotIndex == -1) {
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"message.berrypouch.marked_bait_exhausted"), true);
                return CompoundEventResult.pass();
            }
        }
        if (foundSlotIndex == -1) {
            for (int i = 0; i < pouchItems.size(); ++i) {
                ItemStack stackInSlot = (ItemStack)pouchItems.get(i);
                if (stackInSlot.isEmpty() || !FishingRodEventHandler.isCobblemonBerry(stackInSlot)) continue;
                foundSlotIndex = i;
                baitToUse = stackInSlot;
                usedBaitItem = stackInSlot.getItem();
                break;
            }
        }
        if (foundSlotIndex != -1 && !baitToUse.isEmpty() && usedBaitItem != null) {
            ItemStack baitToSet = baitToUse.copyWithCount(1);
            PokerodItem.Companion.setBait(heldStack, baitToSet);
            ItemStack originalStack = (ItemStack)pouchItems.get(foundSlotIndex);
            originalStack.shrink(1);
            pouchStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)pouchItems));
            PouchDataHelper.setLastUsedBait(pouchStack, usedBaitItem);
            serverPlayer.sendSystemMessage((Component)Component.translatable((String)"message.berrypouch.autobait", (Object[])new Object[]{baitToSet.getHoverName()}), true);
            return CompoundEventResult.interruptTrue((Object)heldStack);
        }
        return CompoundEventResult.pass();
    }

    private static Optional<ItemStack> getEquippedBerryPouch(ServerPlayer player) {
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
        if (capability == null) {
            return Optional.empty();
        }
        Optional pouchRefOpt = capability.getEquipped(stack -> stack.getItem() instanceof BerryPouch).stream().findFirst();
        if (pouchRefOpt.isEmpty()) {
            return Optional.empty();
        }
        ItemStack pouchStack = ((SlotEntryReference)pouchRefOpt.get()).stack();
        if (!(pouchStack.getItem() instanceof BerryPouch)) {
            return Optional.empty();
        }
        return Optional.of(pouchStack);
    }

    private static ItemStack pouchStackCheck(ServerPlayer player) {
        return FishingRodEventHandler.getEquippedBerryPouch(player).orElse(ItemStack.EMPTY);
    }

    public static boolean isCobblemonFishingRod(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.getItem() instanceof PokerodItem;
    }

    public static boolean isCobblemonBerry(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return BerryPouch.isBerry(stack);
    }
}

