/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.recipe;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryDataComponents;
import com.yogpc.qp.machine.module.FilterModuleItem;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class FilterModuleExpandRecipe
extends ShapelessRecipe {
    static final int MAX_ROWS = 6;
    static final int ROW_INCREMENT = 2;
    public static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"filter_module_expand_recipe");
    public static final RecipeSerializer<FilterModuleExpandRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(FilterModuleExpandRecipe::new);
    private final Item moduleItem;

    public FilterModuleExpandRecipe(Item moduleItem, CraftingBookCategory category) {
        super(LOCATION.toString(), category, new ItemStack((ItemLike)moduleItem), FilterModuleExpandRecipe.createIngredients(moduleItem));
        this.moduleItem = moduleItem;
    }

    FilterModuleExpandRecipe(CraftingBookCategory category) {
        this(PlatformAccess.getAccess().registerObjects().filterModuleItem().get(), category);
    }

    static NonNullList<Ingredient> createIngredients(Item moduleItem) {
        Ingredient chest = Ingredient.of((ItemLike[])new ItemLike[]{Items.CHEST});
        Ingredient module = Ingredient.of((ItemLike[])new ItemLike[]{moduleItem});
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{chest, chest, chest, chest, module, chest, chest, chest, chest});
    }

    public boolean matches(CraftingInput input, Level level) {
        if (!super.matches(input, level)) {
            return false;
        }
        ItemStack module = this.findModule(input);
        if (module.isEmpty()) {
            return false;
        }
        int rows = FilterModuleItem.getRowsFromStack(module);
        return rows + 2 <= 6;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack module = this.findModule(input).copy();
        int rows = FilterModuleItem.getRowsFromStack(module);
        module.set(QuarryDataComponents.FILTER_MODULE_ROWS_COMPONENT, (Object)(rows + 2));
        return module;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    ItemStack findModule(CraftingInput input) {
        return input.items().stream().filter(i -> i.getItem() == this.moduleItem).findAny().orElse(ItemStack.EMPTY);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements RecipeBuilder {
        private final RecipeCategory category = RecipeCategory.MISC;
        private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

        public Builder unlockedBy(String name, Criterion<?> criterion) {
            this.criteria.put(name, criterion);
            return this;
        }

        public Builder group(@Nullable String groupName) {
            throw new UnsupportedOperationException("Group definition is not supported");
        }

        public Item getResult() {
            return PlatformAccess.getAccess().registerObjects().filterModuleItem().get();
        }

        public void save(RecipeOutput recipeOutput, ResourceLocation id) {
            Advancement.Builder builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
            FilterModuleExpandRecipe recipe = new FilterModuleExpandRecipe(CraftingBookCategory.MISC);
            AdvancementHolder advancement = builder.build(id.withPrefix("recipes/" + this.category.getFolderName() + "/"));
            recipeOutput.accept(id, (Recipe)recipe, advancement);
        }
    }
}

