/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.placer;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.packet.ClientSync;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPlacerTile
extends QpEntity
implements ClientSync,
Container {
    public static final Map<Direction, Vec3> DIRECTION_VEC3D_MAP;
    private final SimpleContainer container = new PlacerContainer(this, this.getContainerSize());
    private int lastPlacedIndex = 0;
    @NotNull
    public RedStoneMode redstoneMode = RedStoneMode.PULSE;

    protected AbstractPlacerTile(BlockPos pos, BlockState blockState) {
        super(pos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.toClientTag(tag, registries);
        tag.put("container", (Tag)this.container.createTag(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.fromClientTag(tag, registries);
        this.container.fromTag(tag.getList("container", 10), registries);
    }

    @Override
    public void fromClientTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.lastPlacedIndex = tag.getInt("lastPlacedIndex");
        this.redstoneMode = RedStoneMode.valueOf(tag.getString("mode"));
    }

    @Override
    public CompoundTag toClientTag(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("lastPlacedIndex", this.lastPlacedIndex);
        tag.putString("mode", this.redstoneMode.name());
        return tag;
    }

    protected abstract BlockPos getTargetPos();

    protected abstract Direction getMachineFacing();

    @Override
    public Stream<MutableComponent> checkerLogs() {
        return Stream.concat(super.checkerLogs(), Stream.of(AbstractPlacerTile.detail(ChatFormatting.GREEN, "redstoneMode", this.redstoneMode.toString()), AbstractPlacerTile.detail(ChatFormatting.GREEN, "Target", this.getTargetPos().toShortString()), AbstractPlacerTile.detail(ChatFormatting.GREEN, "Facing", String.valueOf(this.getMachineFacing())), AbstractPlacerTile.detail(ChatFormatting.GREEN, "isPowered", String.valueOf(this.isPowered())), AbstractPlacerTile.detail(ChatFormatting.GREEN, "lastPlacedIndex in inv", String.valueOf(this.getLastPlacedIndex()))));
    }

    protected boolean isPowered() {
        assert (this.level != null);
        return Arrays.stream(Direction.values()).filter(Predicate.isEqual(this.getMachineFacing()).negate()).anyMatch(f -> this.level.hasSignal(this.getBlockPos().relative(f), f)) || this.level.hasNeighborSignal(this.getBlockPos().above());
    }

    void breakBlock() {
        if (this.level == null || !this.redstoneMode.canBreak()) {
            return;
        }
        BlockPos pos = this.getTargetPos();
        if (pos.equals((Object)this.getBlockPos())) {
            return;
        }
        BlockState state = this.level.getBlockState(pos);
        if (state.getDestroySpeed((BlockGetter)this.level, pos) < 0.0f) {
            return;
        }
        ServerPlayer fake = PlatformAccess.getAccess().mining().getQuarryFakePlayer(this, (ServerLevel)this.level, pos);
        ItemStack pickaxe = this.getSilkPickaxe();
        fake.setItemInHand(InteractionHand.MAIN_HAND, pickaxe);
        List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)this.level), (BlockPos)pos, (BlockEntity)this.level.getBlockEntity(pos), (Entity)fake, (ItemStack)pickaxe);
        this.level.removeBlock(pos, false);
        drops.stream().map(arg_0 -> ((SimpleContainer)this.container).addItem(arg_0)).filter(Predicate.not(ItemStack::isEmpty)).forEach(s -> Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)s));
    }

    boolean placeBlock() {
        if (this.isEmpty() || !this.redstoneMode.canPlace()) {
            return false;
        }
        Direction facing = this.getMachineFacing();
        BlockPos pos = this.getTargetPos();
        if (pos.equals((Object)this.getBlockPos())) {
            return false;
        }
        Vec3 hitPos = DIRECTION_VEC3D_MAP.get(facing.getOpposite()).add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        BlockHitResult rayTrace = new BlockHitResult(hitPos, facing.getOpposite(), pos, false);
        ServerPlayer fake = PlatformAccess.getAccess().mining().getQuarryFakePlayer(this, (ServerLevel)this.level, pos);
        AtomicBoolean result = new AtomicBoolean(false);
        AbstractPlacerTile.findEntry(this.container.getItems(), arg_0 -> AbstractPlacerTile.lambda$placeBlock$2((Player)fake, rayTrace, arg_0), this.lastPlacedIndex).ifPresent(i -> {
            this.lastPlacedIndex = !this.getItem(i).isEmpty() ? i : AbstractPlacerTile.findEntry(this.container.getItems(), s -> !s.isEmpty() && s.getItem() instanceof BlockItem, i).orElse(0);
            this.setChanged();
            this.syncToClient();
            result.set(true);
        });
        fake.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        return result.get();
    }

    public static <T> OptionalInt findEntry(List<T> check, Predicate<T> filter, int startIndex) {
        int listSize = check.size();
        if (startIndex >= listSize) {
            return OptionalInt.empty();
        }
        return AbstractPlacerTile.findEntryInternal(check, filter, startIndex, startIndex, listSize);
    }

    private static <T> OptionalInt findEntryInternal(List<T> check, Predicate<T> filter, int startIndex, int index, int listSize) {
        T value = check.get(index);
        if (filter.test(value)) {
            return OptionalInt.of(index);
        }
        if (index == startIndex - 1 || startIndex == 0 && index == listSize - 1) {
            return OptionalInt.empty();
        }
        int next = index + 1 == listSize ? 0 : index + 1;
        return AbstractPlacerTile.findEntryInternal(check, filter, startIndex, next, listSize);
    }

    static boolean tryPlaceItem(ItemStack stack, Player fake, BlockHitResult rayTrace) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            fake.setItemInHand(InteractionHand.MAIN_HAND, stack);
            BlockPlaceContext context = new BlockPlaceContext(new UseOnContext(fake, InteractionHand.MAIN_HAND, rayTrace));
            return blockItem.place(context).consumesAction();
        }
        return false;
    }

    public int getLastPlacedIndex() {
        return this.lastPlacedIndex;
    }

    protected ItemStack getSilkPickaxe() {
        assert (this.level != null);
        ItemStack stack = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
        stack.enchant((Holder)this.level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH), 1);
        return stack;
    }

    public int getContainerSize() {
        return 9;
    }

    public boolean isEmpty() {
        return this.container.isEmpty();
    }

    public ItemStack getItem(int slot) {
        return this.container.getItem(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.container.removeItem(slot, amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.container.removeItemNoUpdate(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.container.setItem(slot, stack);
    }

    public boolean stillValid(Player player) {
        return this.getBlockPos().closerToCenterThan((Position)player.position(), 8.0);
    }

    public void clearContent() {
        this.container.clearContent();
    }

    public void cycleRedStoneMode() {
        this.redstoneMode = RedStoneMode.cycle(this.redstoneMode);
        if (this.level != null && !this.level.isClientSide) {
            this.syncToClient();
        }
    }

    private static /* synthetic */ boolean lambda$placeBlock$2(Player fake, BlockHitResult rayTrace, ItemStack i) {
        return AbstractPlacerTile.tryPlaceItem(i, fake, rayTrace);
    }

    static {
        EnumMap<Direction, Vec3> map = new EnumMap<Direction, Vec3>(Direction.class);
        map.put(Direction.DOWN, new Vec3(0.5, 0.0, 0.5));
        map.put(Direction.UP, new Vec3(0.5, 1.0, 0.5));
        map.put(Direction.NORTH, new Vec3(0.5, 0.5, 0.0));
        map.put(Direction.SOUTH, new Vec3(0.5, 0.5, 1.0));
        map.put(Direction.EAST, new Vec3(1.0, 0.5, 0.5));
        map.put(Direction.WEST, new Vec3(0.0, 0.5, 0.5));
        DIRECTION_VEC3D_MAP = Collections.unmodifiableMap(map);
    }

    private static final class PlacerContainer
    extends SimpleContainer {
        private final QpEntity parent;

        public PlacerContainer(QpEntity parent, int size) {
            super(size);
            this.parent = parent;
        }

        public void setChanged() {
            super.setChanged();
            this.parent.setChanged();
        }
    }

    public static enum RedStoneMode {
        PULSE(true, true),
        PULSE_PLACE_ONLY(true, false),
        PULSE_BREAK_ONLY(false, true);

        private final boolean placeEnabled;
        private final boolean breakEnabled;

        private RedStoneMode(boolean placeEnabled, boolean breakEnabled) {
            this.placeEnabled = placeEnabled;
            this.breakEnabled = breakEnabled;
        }

        public String toString() {
            return this.name().replace('_', ' ');
        }

        public boolean canPlace() {
            return this.placeEnabled;
        }

        public boolean canBreak() {
            return this.breakEnabled;
        }

        public static RedStoneMode cycle(RedStoneMode now) {
            RedStoneMode[] modes = RedStoneMode.values();
            for (int i = 0; i < modes.length; ++i) {
                RedStoneMode mode = modes[i];
                if (mode != now) continue;
                if (i + 1 == modes.length) {
                    return modes[0];
                }
                return modes[i + 1];
            }
            return modes[0];
        }
    }
}

