/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.mover;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.enchantment.QuarryPickaxeEnchantment;
import com.yogpc.qp.machine.GeneralScreenHandler;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpEntityBlock;
import com.yogpc.qp.machine.mover.MoverContainer;
import com.yogpc.qp.machine.mover.MoverEntity;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public final class MoverBlock
extends QpEntityBlock {
    public static final String NAME = "mover";

    public MoverBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).pushReaction(PushReaction.BLOCK).strength(1.2f), NAME, b -> new BlockItem((Block)b, new Item.Properties()));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MoverEntity) {
            MoverEntity entity = (MoverEntity)blockEntity;
            if (!level.isClientSide()) {
                if (entity.enabled) {
                    PlatformAccess.getAccess().openGui((ServerPlayer)player, new GeneralScreenHandler<MoverContainer>(entity, MoverContainer::new));
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.getName()}), true);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof MoverEntity) {
            MoverEntity entity = (MoverEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)entity.inventory);
            level.updateNeighbourForOutputSignal(pos, state.getBlock());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Override
    public Stream<ItemStack> creativeTabItem(CreativeModeTab.ItemDisplayParameters parameters) {
        HolderLookup.RegistryLookup enchantments = parameters.holders().lookupOrThrow(Registries.ENCHANTMENT);
        Stream.Builder<ItemStack> builder = Stream.builder();
        ItemStack stack = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
        stack.enchant((Holder)enchantments.getOrThrow(Enchantments.EFFICIENCY), 5);
        stack.enchant((Holder)enchantments.getOrThrow(QuarryPickaxeEnchantment.KEY), 1);
        builder.add(stack);
        stack = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
        stack.enchant((Holder)enchantments.getOrThrow(Enchantments.EFFICIENCY), 5);
        stack.enchant((Holder)enchantments.getOrThrow(Enchantments.UNBREAKING), 3);
        stack.enchant((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), 3);
        builder.add(stack);
        stack = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
        stack.enchant((Holder)enchantments.getOrThrow(Enchantments.EFFICIENCY), 5);
        stack.enchant((Holder)enchantments.getOrThrow(Enchantments.UNBREAKING), 3);
        stack.enchant((Holder)enchantments.getOrThrow(Enchantments.SILK_TOUCH), 1);
        builder.add(stack);
        return Stream.concat(super.creativeTabItem(parameters), builder.build());
    }

    @Override
    protected QpBlock createBlock(BlockBehaviour.Properties properties) {
        return new MoverBlock();
    }
}

