/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.misc;

import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.misc.Direction26;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FrameBlock
extends QpBlock {
    public static final String NAME = "frame";
    public static final BooleanProperty DAMMING = BooleanProperty.create((String)"damming");
    public static final VoxelShape BOX_AABB = Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
    private static final BiPredicate<Level, BlockPos> HAS_NEIGHBOUR_LIQUID = (world, pos) -> Stream.of(Direction.values()).map(arg_0 -> ((BlockPos)pos).relative(arg_0)).anyMatch(p -> !world.getFluidState(p).isEmpty());
    private boolean breaking = false;

    public FrameBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.NONE).strength(0.5f).noLootTable(), NAME, b -> new BlockItem((Block)b, new Item.Properties()));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)DAMMING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.NORTH, BlockStateProperties.EAST, BlockStateProperties.SOUTH, BlockStateProperties.WEST, BlockStateProperties.UP, BlockStateProperties.DOWN, DAMMING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level worldIn = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.north())))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.east())))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.south())))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.west())))).setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.below())))).setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.above())));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos currentPos, BlockPos neighborPos) {
        return (BlockState)state.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)world, currentPos.relative(direction))));
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.getBlock() != newState.getBlock()) {
            if (!this.breaking) {
                this.breaking = true;
                if (!HAS_NEIGHBOUR_LIQUID.test(world, pos)) {
                    this.breakChain(world, pos);
                }
                this.breaking = false;
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    private void breakChain(Level world, BlockPos first) {
        if (!world.isClientSide) {
            HashSet<BlockPos> set = new HashSet<BlockPos>();
            set.add(first);
            ArrayList<BlockPos> current = new ArrayList<BlockPos>();
            current.add(first);
            while (!current.isEmpty()) {
                ArrayList<BlockPos> nextCheck = new ArrayList<BlockPos>();
                for (BlockPos pos2 : current) {
                    for (Direction26 dir : Direction26.DIRECTIONS) {
                        BlockPos nPos = pos2.offset(dir.vec());
                        BlockState nBlock = world.getBlockState(nPos);
                        if (nBlock.getBlock() != this || HAS_NEIGHBOUR_LIQUID.test(world, nPos) || !set.add(nPos)) continue;
                        nextCheck.add(nPos);
                    }
                }
                current = nextCheck;
            }
            set.forEach(pos -> world.removeBlock(pos, false));
        }
    }

    private boolean canConnectTo(BlockGetter worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos).is((Block)this);
    }

    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        return true;
    }

    public BlockState getDammingState() {
        return (BlockState)this.defaultBlockState().setValue((Property)DAMMING, (Comparable)Boolean.valueOf(true));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return BOX_AABB;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.neighborChanged(state, world, pos, block, fromPos, notify);
        if (((Boolean)state.getValue((Property)DAMMING)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)DAMMING, (Comparable)Boolean.valueOf(HAS_NEIGHBOUR_LIQUID.test(world, pos))), 2);
        }
    }

    @Override
    protected QpBlock createBlock(BlockBehaviour.Properties properties) {
        return new FrameBlock();
    }
}

