/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.QpBlock;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class QpEntity
extends BlockEntity {
    public final boolean enabled;

    protected QpEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.enabled = PlatformAccess.config().enableMap().enabled(this.getMachineName(type));
    }

    protected QpEntity(BlockPos pos, BlockState blockState) {
        this(PlatformAccess.getAccess().registerObjects().getBlockEntityType((QpBlock)blockState.getBlock()).orElseThrow(), pos, blockState);
    }

    protected String getMachineName(BlockEntityType<?> type) {
        ResourceLocation key = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(type);
        if (key == null) {
            return "invalid";
        }
        return key.getPath();
    }

    public Stream<MutableComponent> checkerLogs() {
        return Stream.of(Component.literal((String)"-".repeat(32)), Component.empty().append((Component)Component.literal((String)"BlockEntity").withStyle(ChatFormatting.AQUA)).append(": %s".formatted(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)this.getType()))).append(" (%s)".formatted(((Object)((Object)this)).getClass().getSimpleName())), QpEntity.detail(ChatFormatting.AQUA, "Enabled", String.valueOf(this.enabled)), QpEntity.detail(ChatFormatting.AQUA, "Pos", this.getBlockPos().toShortString()));
    }

    protected static MutableComponent detail(ChatFormatting color, String title, String content) {
        return Component.empty().append((Component)Component.literal((String)title).withStyle(color)).append(": ").append(content);
    }
}

