/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.EnergyCounter;
import com.yogpc.qp.machine.QpEntity;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class PowerEntity
extends QpEntity {
    public static final long ONE_FE = 1000000000L;
    protected final EnergyCounter energyCounter;
    private LongSupplier timeProvider;
    private long energy;
    private long maxEnergy;
    private final boolean noEnergy;

    protected PowerEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.energyCounter = EnergyCounter.createInstance(PlatformAccess.config().debug(), "%s(%d, %d, %d)".formatted(((Object)((Object)this)).getClass().getSimpleName(), pos.getX(), pos.getY(), pos.getZ()));
        this.setTimeProvider(() -> Objects.requireNonNull(this.level, "Level in block entity is null. Are you in test?\nMake sure to run `setTimeProvider` to replace the default time provider.").getGameTime());
        this.noEnergy = PlatformAccess.config().noEnergy();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putLong("energy", this.energy);
        tag.putLong("maxEnergy", this.maxEnergy);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.energy = tag.getLong("energy");
        this.setMaxEnergy(tag.getLong("maxEnergy"));
    }

    public final long getEnergy() {
        if (this.noEnergy) {
            return this.maxEnergy;
        }
        return this.energy;
    }

    public final long getMaxEnergy() {
        return this.maxEnergy;
    }

    protected final boolean hasEnoughEnergy() {
        return this.enabled && this.getEnergy() > 0L;
    }

    protected long getMaxReceive() {
        return this.maxEnergy;
    }

    protected final void setMaxEnergy(long maxEnergy) {
        this.maxEnergy = maxEnergy;
    }

    public abstract void updateMaxEnergyWithEnchantment(Level var1);

    @VisibleForTesting
    public void setTimeProvider(LongSupplier timeProvider) {
        this.timeProvider = timeProvider;
    }

    public final long addEnergy(long amount, boolean simulate) {
        if (this.noEnergy) {
            return 0L;
        }
        long accepted = Math.min(Math.min(this.maxEnergy - this.energy, amount), this.getMaxReceive());
        if (!simulate && accepted >= 0L) {
            this.energy += accepted;
            this.energyCounter.getEnergy(this.timeProvider, accepted);
            this.setChanged();
        }
        return accepted;
    }

    public final long useEnergy(long amount, boolean simulate, boolean force, String reason) {
        long used;
        if (this.noEnergy) {
            this.energyCounter.useEnergy(this.timeProvider, amount, reason);
            return amount;
        }
        long l = used = force ? amount : Math.min(amount, this.energy);
        if (!simulate && used >= 0L) {
            this.energy -= used;
            this.energyCounter.useEnergy(this.timeProvider, used, reason);
            this.setChanged();
        }
        return used;
    }

    public final void setEnergy(long energy, boolean log) {
        if (this.noEnergy) {
            return;
        }
        if (this.energy > energy) {
            this.energyCounter.useEnergy(log ? this.timeProvider : () -> 1L, this.energy - energy, "FORCE_SET");
        } else {
            this.energyCounter.getEnergy(log ? this.timeProvider : () -> 1L, energy - this.energy);
        }
        this.setChanged();
        this.energy = energy;
    }

    @Override
    public Stream<MutableComponent> checkerLogs() {
        return Stream.concat(super.checkerLogs(), Stream.of(PowerEntity.detail(ChatFormatting.AQUA, "Energy", "%d / %d".formatted(this.getEnergy() / 1000000000L, this.getMaxEnergy() / 1000000000L))));
    }

    public static BlockEntityTicker<PowerEntity> logTicker() {
        return (w, p, s, blockEntity) -> blockEntity.energyCounter.logOutput(blockEntity.timeProvider.getAsLong());
    }
}

