/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yogpc.qp.PlatformAccess;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public final class MachineLootFunction
extends LootItemConditionalFunction {
    public static final String NAME = "machine_loot_function";
    public static final MapCodec<MachineLootFunction> SERIALIZER = RecordCodecBuilder.mapCodec(instance -> MachineLootFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, MachineLootFunction::new));

    private MachineLootFunction(List<LootItemCondition> conditions) {
        super(conditions);
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        BlockEntity blockEntity = (BlockEntity)context.getParam(LootContextParams.BLOCK_ENTITY);
        MachineLootFunction.process(stack, blockEntity);
        return stack;
    }

    public LootItemFunctionType<? extends MachineLootFunction> getType() {
        return PlatformAccess.getAccess().registerObjects().machineLootFunction().get();
    }

    public static void process(ItemStack stack, BlockEntity entity) {
        stack.applyComponents(entity.collectComponents());
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return LootItemConditionalFunction.simpleBuilder(MachineLootFunction::new);
    }
}

